/*
 * Decompiled with CFR 0.152.
 */
package net.mehdinoui.veggiesdelight.world;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.mehdinoui.veggiesdelight.Configuration;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

public class VillageStructures {
    public static void addNewVillageBuilding(ServerAboutToStartEvent event) {
        if (!((Boolean)Configuration.GENERATE_VILLAGE_STRUCTURES.get()).booleanValue()) {
            return;
        }
        Registry templatePools = (Registry)event.getServer().registryAccess().registry(Registries.TEMPLATE_POOL).get();
        Registry processorLists = (Registry)event.getServer().registryAccess().registry(Registries.PROCESSOR_LIST).get();
        if (((Boolean)Configuration.GENERATE_VANILLA_VS.get()).booleanValue()) {
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/plains/houses"), "veggiesdelight:village/houses/plains_depot_house", 4);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/snowy/houses"), "veggiesdelight:village/houses/snowy_depot_house", 5);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/taiga/houses"), "veggiesdelight:village/houses/taiga_depot_house", 4);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/savanna/houses"), "veggiesdelight:village/houses/savanna_depot_house", 4);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"minecraft:village/desert/houses"), "veggiesdelight:village/houses/desert_depot_house", 4);
        }
        if (ModList.get().isLoaded("atmospheric") && ((Boolean)Configuration.GENERATE_COMPAT_ATMOSPHERIC_VS.get()).booleanValue()) {
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"atmospheric:village/scrubland/houses"), "veggiesdelight:compat/atmospheric/village/houses/scrubland_depot_house", 4);
        }
        if (ModList.get().isLoaded("natures_spirit") && ((Boolean)Configuration.GENERATE_COMPAT_NATURESPIRIT_VS.get()).booleanValue()) {
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"natures_spirit:village/adobe/adobe_houses_layer_1_back"), "veggiesdelight:compat/natures_spirit/village/houses/adobe_depot_house", 4);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"natures_spirit:village/coconut/houses"), "veggiesdelight:compat/natures_spirit/village/houses/coconut_depot_house", 4);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"natures_spirit:village/cypress/houses"), "veggiesdelight:compat/natures_spirit/village/houses/cypress_depot_house", 4);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"natures_spirit:village/wisteria/houses"), "veggiesdelight:compat/natures_spirit/village/houses/wisteria_depot_house", 4);
        }
        if (ModList.get().isLoaded("repurposed_structures") && ((Boolean)Configuration.GENERATE_COMPAT_REPURPOSED_STRUCTURES_VS.get()).booleanValue()) {
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"repurposed_structures:villages/badlands/houses"), "veggiesdelight:compat/repurposed_structures/village/houses/badlands_depot_house", 4);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"repurposed_structures:villages/bamboo/houses"), "veggiesdelight:compat/repurposed_structures/village/houses/bamboo_depot_house", 4);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"repurposed_structures:villages/birch/houses"), "veggiesdelight:compat/repurposed_structures/village/houses/birch_depot_house", 5);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"repurposed_structures:villages/cherry/houses"), "veggiesdelight:compat/repurposed_structures/village/houses/cherry_depot_house", 4);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"repurposed_structures:villages/dark_forest/houses"), "veggiesdelight:compat/repurposed_structures/village/houses/dark_forest_depot_house", 5);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"repurposed_structures:villages/giant_taiga/houses"), "veggiesdelight:compat/repurposed_structures/village/houses/giant_taiga_depot_house", 5);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"repurposed_structures:villages/jungle/houses"), "veggiesdelight:compat/repurposed_structures/village/houses/jungle_depot_house", 4);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"repurposed_structures:villages/mountain/houses"), "veggiesdelight:compat/repurposed_structures/village/houses/mountain_depot_house", 4);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"repurposed_structures:villages/mushroom/houses"), "veggiesdelight:compat/repurposed_structures/village/houses/mushroom_depot_house", 4);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"repurposed_structures:villages/oak/houses"), "veggiesdelight:compat/repurposed_structures/village/houses/oak_depot_house", 5);
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"repurposed_structures:villages/swamp/houses"), "veggiesdelight:compat/repurposed_structures/village/houses/swamp_depot_house", 4);
        }
        if (ModList.get().isLoaded("explorify") && ((Boolean)Configuration.GENERATE_COMPAT_DARK_FOREST_SETTLEMENT_VS.get()).booleanValue()) {
            VillageStructures.addBuildingToPool((Registry<StructureTemplatePool>)templatePools, (Registry<StructureProcessorList>)processorLists, ResourceLocation.parse((String)"explorify:dark_forest_settlement/house"), "veggiesdelight:compat/explorify/village/houses/settlement_depot_house", 3);
        }
    }

    public static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, ResourceLocation poolRL, String nbtPieceRL, int weight) {
        StructureTemplatePool pool = (StructureTemplatePool)templatePoolRegistry.get(poolRL);
        if (pool == null) {
            return;
        }
        ResourceLocation emptyProcessor = ResourceLocation.withDefaultNamespace((String)"empty");
        Holder.Reference processorHolder = processorListRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)emptyProcessor));
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.single((String)nbtPieceRL, (Holder)processorHolder).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.rawTemplates);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.rawTemplates = listOfPieceEntries;
    }
}

