/*
 * Decompiled with CFR 0.152.
 */
package com.matibi.thealchemiststouch.client.modmenu.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.matibi.thealchemiststouch.TheAlchemistsTouch;
import com.matibi.thealchemiststouch.potion.ModPotion;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public final class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File FILE;
    public static final Set<class_2960> DISABLED_POTIONS;
    public static final Set<class_6880<class_1842>> PROTECTED_POTIONS;

    public static void init(File configDir) {
        FILE = new File(configDir, "the_alchemists_touch.json");
        ModConfig.load();
    }

    public static boolean isPotionDisabled(class_1842 potion) {
        class_2960 id = class_7923.field_41179.method_10221((Object)potion);
        if (id == null) {
            return false;
        }
        for (class_6880<class_1842> protectedEntry : PROTECTED_POTIONS) {
            if (!protectedEntry.method_40225((class_5321)class_7923.field_41179.method_29113((Object)potion).orElseThrow())) continue;
            return false;
        }
        class_2960 base = ModConfig.basePotionId(id);
        return DISABLED_POTIONS.contains(id) || DISABLED_POTIONS.contains(base);
    }

    public static class_2960 basePotionId(class_2960 id) {
        String ns = id.method_12836();
        String p = id.method_12832();
        boolean changed = true;
        while (changed) {
            changed = false;
            if (p.startsWith("long_")) {
                p = p.substring(5);
                changed = true;
            }
            if (!p.startsWith("strong_")) continue;
            p = p.substring(7);
            changed = true;
        }
        return class_2960.method_60655((String)ns, (String)p);
    }

    public static void load() {
        try {
            if (!FILE.exists()) {
                ModConfig.save();
                return;
            }
            try (FileReader r = new FileReader(FILE);){
                Dto dto = (Dto)GSON.fromJson((Reader)r, Dto.class);
                DISABLED_POTIONS.clear();
                if (dto != null && dto.disabledPotions != null) {
                    for (String s : dto.disabledPotions) {
                        DISABLED_POTIONS.add(class_2960.method_60654((String)s));
                    }
                }
            }
        }
        catch (Exception e) {
            TheAlchemistsTouch.LOGGER.error("Failed to load config", (Throwable)e);
        }
    }

    public static void save() {
        try (FileWriter w = new FileWriter(FILE);){
            Dto dto = new Dto();
            dto.disabledPotions = DISABLED_POTIONS.stream().filter(id -> !ModConfig.isProtectedId(id)).map(class_2960::toString).toList();
            GSON.toJson((Object)dto, (Appendable)w);
        }
        catch (Exception e) {
            TheAlchemistsTouch.LOGGER.error("Failed to load config", (Throwable)e);
        }
    }

    private static boolean isProtectedId(class_2960 id) {
        for (class_6880<class_1842> entry : PROTECTED_POTIONS) {
            class_2960 entryId = class_7923.field_41179.method_10221((Object)((class_1842)entry.comp_349()));
            if (!id.equals((Object)entryId)) continue;
            return true;
        }
        return false;
    }

    static {
        DISABLED_POTIONS = new HashSet<class_2960>();
        PROTECTED_POTIONS = Set.of(class_1847.field_8991, class_1847.field_8999, class_1847.field_8985, class_1847.field_8967, class_1847.field_8995, ModPotion.UNSTABLE);
    }

    private static final class Dto {
        List<String> disabledPotions;

        private Dto() {
        }
    }
}

