/*
 * Decompiled with CFR 0.152.
 */
package com.matibi.thealchemiststouch.effect.custom;

import com.matibi.thealchemiststouch.effect.ModEffects;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1844;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_4081;
import net.minecraft.class_5743;

public class ResonanceEffect
extends class_1291 {
    private static final int ORBIT_POINTS = 16;
    private static final int PULSE_POINTS = 40;
    private static final float SCALE_ORBIT = 0.45f;
    private static final float SCALE_PULSE = 0.65f;
    private static final int PULSE_PERIOD = 24;
    private static final double ORBIT_SPEED_BASE = 0.08;
    private static final int DEFAULT_COLOR = 10545376;

    public ResonanceEffect() {
        super(class_4081.field_18273, 10545376);
    }

    public boolean method_5552(int duration, int amplifier) {
        return true;
    }

    public boolean method_5572(class_3218 world, class_1309 entity, int amplifier) {
        double maxRadius = 4.0 + (double)amplifier * 2.0;
        List<class_1293> effects = entity.method_6026().stream().filter(e -> !e.method_5579().equals(ModEffects.RESONANCE)).toList();
        OptionalInt rgb = class_1844.method_58111(effects);
        int baseColor = rgb.isEmpty() ? 10545376 : rgb.getAsInt();
        int centerColor = ResonanceEffect.lighten(baseColor);
        ResonanceEffect.spawnPulseWave(world, entity, amplifier, maxRadius, centerColor, baseColor);
        ResonanceEffect.spawnOrbitRing(world, entity, amplifier, maxRadius, baseColor);
        class_1293 self = entity.method_6112(ModEffects.RESONANCE);
        if (self != null && self.method_5584() % 40 == 0 && !effects.isEmpty()) {
            List nearby = world.method_8390(class_1309.class, entity.method_5829().method_1014(maxRadius), e -> e != entity && e.method_5805());
            for (class_1309 target : nearby) {
                for (class_1293 effect : effects) {
                    class_1293 copy = new class_1293(effect.method_5579(), Math.max(1, effect.method_5584() / 2), effect.method_5578());
                    target.method_6092(copy);
                }
            }
        }
        return true;
    }

    private static void spawnPulseWave(class_3218 world, class_1309 entity, int amplifier, double maxRadius, int centerColor, int edgeColor) {
        int period = Math.max(8, 24 - amplifier * 2);
        double phase = (double)((world.method_8510() + (long)(entity.method_5628() & 7)) % (long)period) / (double)period;
        double eased = ResonanceEffect.easeOutSine(phase);
        double r = 0.5 + eased * (maxRadius - 0.5);
        double y = entity.method_23318() + (double)entity.method_17682() * 0.55;
        double step = 0.15707963267948966;
        class_5743 pulse = new class_5743(centerColor, edgeColor, 0.65f);
        for (int i = 0; i < 40; ++i) {
            double angle = (double)i * step;
            double x = entity.method_23317() + Math.cos(angle) * r;
            double z = entity.method_23321() + Math.sin(angle) * r;
            world.method_65096((class_2394)pulse, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void spawnOrbitRing(class_3218 world, class_1309 entity, int amplifier, double radius, int baseColor) {
        double speed = 0.08 + (double)amplifier * 0.02;
        double t = (double)world.method_8510() * speed;
        double y = entity.method_23318() + (double)entity.method_17682() * 0.6;
        double phaseOffset = (double)(entity.method_5628() & 0xF) * 0.25;
        double step = 0.39269908169872414;
        class_2390 orbit = new class_2390(baseColor, 0.45f);
        for (int i = 0; i < 16; ++i) {
            double angle = t + phaseOffset + (double)i * step;
            double x = entity.method_23317() + Math.cos(angle) * radius;
            double z = entity.method_23321() + Math.sin(angle) * radius;
            world.method_65096((class_2394)orbit, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static int lighten(int color) {
        float amount = 0.35f;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = ResonanceEffect.clamp255((int)((float)r + (float)(255 - r) * amount));
        g = ResonanceEffect.clamp255((int)((float)g + (float)(255 - g) * amount));
        b = ResonanceEffect.clamp255((int)((float)b + (float)(255 - b) * amount));
        return r << 16 | g << 8 | b;
    }

    private static int clamp255(int v) {
        return Math.max(0, Math.min(255, v));
    }

    private static double easeOutSine(double x) {
        return Math.sin(x * Math.PI / 2.0);
    }
}

