/*
 * Decompiled with CFR 0.152.
 */
package com.matibi.thealchemiststouch.entity;

import com.matibi.thealchemiststouch.particle.CloudEffectData;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.random.RandomGenerator;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1844;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;

public class EffectCloud
extends class_1297 {
    private static final class_2940<Integer> MAX_BLOCKS = class_2945.method_12791(EffectCloud.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> LIFETIME_TICKS = class_2945.method_12791(EffectCloud.class, (class_2941)class_2943.field_13327);
    private final Set<class_2338> occupied = new HashSet<class_2338>();
    private List<class_1293> effects = new ArrayList<class_1293>();

    public EffectCloud(class_1299<? extends EffectCloud> type, class_1937 world) {
        super(type, world);
        this.field_5960 = true;
        this.method_5648(true);
    }

    public void setLifetimeTicks(int ticks) {
        int v = ticks == -1 ? -1 : Math.max(0, ticks);
        this.method_5841().method_12778(LIFETIME_TICKS, (Object)v);
    }

    public void setLifetimeSeconds(int seconds) {
        this.setLifetimeTicks(seconds < 0 ? -1 : seconds * 20);
    }

    public int getLifetimeTicks() {
        return (Integer)this.method_5841().method_12789(LIFETIME_TICKS);
    }

    public boolean isLifetimeInfinite() {
        return this.getLifetimeTicks() == -1;
    }

    public void setMAX_BLOCKS(int size) {
        size = Math.max(1, size);
        this.method_5841().method_12778(MAX_BLOCKS, (Object)size);
    }

    public int getMAX_BLOCKS() {
        return (Integer)this.method_5841().method_12789(MAX_BLOCKS);
    }

    public void setEffects(Collection<class_1293> fx) {
        this.effects = new ArrayList<class_1293>(fx);
    }

    public List<class_1293> getEffects() {
        return this.effects;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(MAX_BLOCKS, (Object)64);
        builder.method_56912(LIFETIME_TICKS, (Object)-1);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_73183().method_8608()) {
            int life = this.getLifetimeTicks();
            if (life > 0) {
                this.setLifetimeTicks(life - 1);
            } else if (life == 0) {
                this.method_31472();
                return;
            }
        }
        this.recomputeOccupiedVoxels();
        this.spawnParticlesClient();
        this.applyEffectsToEntities();
    }

    private void recomputeOccupiedVoxels() {
        this.occupied.clear();
        class_2338 origin = this.method_24515();
        if (this.isSolid(origin)) {
            return;
        }
        ArrayDeque<class_2338> q = new ArrayDeque<class_2338>();
        q.add(origin);
        this.occupied.add(origin);
        block0: while (!q.isEmpty() && this.occupied.size() < this.getMAX_BLOCKS()) {
            class_2338 p = (class_2338)q.poll();
            if (p == null) {
                return;
            }
            for (class_2350 d : class_2350.values()) {
                class_2338 n = p.method_10093(d);
                if (this.occupied.contains(n) || this.isSolid(n) || Math.abs(n.method_10264() - origin.method_10264()) > 32) continue;
                this.occupied.add(n);
                if (this.occupied.size() >= this.getMAX_BLOCKS()) continue block0;
                q.add(n);
            }
        }
    }

    private boolean isSolid(class_2338 pos) {
        class_2680 state = this.method_73183().method_8320(pos);
        class_265 shape = state.method_26220((class_1922)this.method_73183(), pos);
        return !shape.method_1110();
    }

    private void applyEffectsToEntities() {
        if (this.occupied.isEmpty() || this.effects.isEmpty()) {
            return;
        }
        class_238 bounds = this.computeBounds(this.occupied).method_1014(1.0);
        List list = this.method_73183().method_8390(class_1309.class, bounds, e -> e.method_5805() && !e.method_7325());
        for (class_1309 le : list) {
            class_2338 feet = le.method_24515();
            boolean inside = this.occupied.contains(feet) || this.occupied.contains(feet.method_10084());
            for (class_1293 template : this.effects) {
                class_6880 type = template.method_5579();
                int amp = template.method_5578();
                class_1293 active = le.method_6112(type);
                if (inside) {
                    boolean needApply = active == null || active.method_5578() != amp;
                    if (!needApply) continue;
                    le.method_6092(new class_1293(type, -1, amp, true, false, true));
                    continue;
                }
                if (active == null || active.method_5584() != -1) continue;
                le.method_6016(type);
            }
        }
    }

    private class_238 computeBounds(Set<class_2338> vox) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_2338 p : vox) {
            if (p.method_10263() < minX) {
                minX = p.method_10263();
            }
            if (p.method_10264() < minY) {
                minY = p.method_10264();
            }
            if (p.method_10260() < minZ) {
                minZ = p.method_10260();
            }
            if (p.method_10263() > maxX) {
                maxX = p.method_10263();
            }
            if (p.method_10264() > maxY) {
                maxY = p.method_10264();
            }
            if (p.method_10260() <= maxZ) continue;
            maxZ = p.method_10260();
        }
        return new class_238((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    private void spawnParticlesClient() {
        if (!this.method_73183().method_8608() || this.occupied.isEmpty()) {
            return;
        }
        class_638 world = (class_638)this.method_73183();
        class_5819 r = world.field_9229;
        int rgb = class_1844.method_58111(this.effects).orElse(15527857);
        Random random = Random.from(RandomGenerator.getDefault());
        this.occupied.forEach(p -> {
            if (random.nextFloat() < 0.05f) {
                double x = (double)p.method_10263() + 0.5 + (r.method_43058() - 0.5);
                double y = (double)p.method_10264() + 0.5 + r.method_43058() * 0.5;
                double z = (double)p.method_10260() + 0.5 + (r.method_43058() - 0.5);
                double vx = (r.method_43058() - 0.5) * 0.02;
                double vy = 0.005 + r.method_43058() * 0.01;
                double vz = (r.method_43058() - 0.5) * 0.02;
                world.method_8406((class_2394)new CloudEffectData(rgb), x, y, z, vx, vy, vz);
            }
        });
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return false;
    }

    public boolean method_5732() {
        return false;
    }

    protected void method_5749(class_11368 view) {
        this.setMAX_BLOCKS(view.method_71424("MaxBlocks", this.getMAX_BLOCKS()));
        this.effects = view.method_71426("Effects", class_1293.field_48821.listOf()).orElseGet(ArrayList::new);
        this.setLifetimeTicks(view.method_71424("Lifetime", -1));
    }

    protected void method_5652(class_11372 view) {
        view.method_71465("MaxBlocks", this.getMAX_BLOCKS());
        view.method_71468("Effects", class_1293.field_48821.listOf(), this.effects);
        view.method_71465("Lifetime", this.getLifetimeTicks());
    }
}

