/*
 * Decompiled with CFR 0.152.
 */
package com.matibi.thealchemiststouch.block.entity;

import com.matibi.thealchemiststouch.TheAlchemistsTouch;
import com.matibi.thealchemiststouch.block.entity.ImplementedInventory;
import com.matibi.thealchemiststouch.block.entity.ModBlockEntities;
import com.matibi.thealchemiststouch.network.RitualCircleSyncS2CPayload;
import com.matibi.thealchemiststouch.ritual.Ritual;
import com.matibi.thealchemiststouch.ritual.RitualRegistry;
import com.matibi.thealchemiststouch.screen.RitualCircleScreenHandler;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class RitualCircleBlockEntity
extends class_2586
implements ImplementedInventory,
ExtendedScreenHandlerFactory<class_2338> {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private int bloodAmount = 1;
    private static final int MAX_BLOOD = 300;
    private class_2350 facing = class_2350.field_11043;
    private Ritual currentRitual = null;
    private int ritualTicks = 0;
    private boolean isPerforming = false;

    public RitualCircleBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.RITUAL_CIRCLE_BE, pos, state);
    }

    public void tryTriggerRitual(class_3218 world, RitualCircleBlockEntity circle, class_1657 player) {
        for (Ritual ritual : RitualRegistry.RITUAL) {
            if (!ritual.checkConditions(world, circle, player) || ritual.getIngredient() != circle.getIngredient().method_7909() || circle.getBlood() < ritual.bloodCost() || player.field_7520 < ritual.xpLvlCost()) continue;
            this.currentRitual = ritual;
            this.ritualTicks = 0;
            this.isPerforming = true;
            this.method_5431();
            world.method_20290(1035, this.field_11867, 0);
            TheAlchemistsTouch.LOGGER.info("Rituel commenc\u00e9 : {}", (Object)ritual.getClass().getSimpleName());
            return;
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, RitualCircleBlockEntity circle) {
        if (world.method_8608() || !circle.isPerforming || circle.currentRitual == null) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_1657 ritualPlayer = serverWorld.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 6.0, false);
        if (ritualPlayer == null) {
            circle.finishRitual(serverWorld, pos, state, null, false);
            return;
        }
        if (!circle.currentRitual.checkConditions(serverWorld, circle, ritualPlayer)) {
            serverWorld.method_8437(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 2.5f, class_1937.class_7867.field_40889);
            circle.finishRitual(serverWorld, pos, state, ritualPlayer, false);
            return;
        }
        ++circle.ritualTicks;
        float progress = (float)circle.ritualTicks / (float)circle.currentRitual.duration();
        progress = Math.min(progress, 1.0f);
        circle.currentRitual.playEffects(serverWorld, pos, progress);
        if (circle.ritualTicks >= circle.currentRitual.duration()) {
            boolean success = world.field_9229.method_43057() <= circle.currentRitual.successChance(serverWorld, ritualPlayer);
            circle.finishRitual(serverWorld, pos, state, ritualPlayer, success);
        }
    }

    private void finishRitual(class_3218 world, class_2338 pos, class_2680 state, @Nullable class_1657 player, boolean success) {
        if (this.currentRitual == null) {
            return;
        }
        int bloodCost = this.currentRitual.bloodCost();
        int xpCost = this.currentRitual.xpLvlCost();
        if (player != null) {
            int xpToConsume = Math.min(player.field_7520, xpCost);
            player.method_7316(-xpToConsume);
        }
        int bloodToConsume = Math.min(this.getBlood(), bloodCost);
        this.setBlood(this.getBlood() - bloodToConsume);
        if (this.currentRitual.consumeItem()) {
            ((class_1799)this.inventory.getFirst()).method_7934(1);
        }
        if (success) {
            this.currentRitual.completeRitual(world, pos, this, player);
            TheAlchemistsTouch.LOGGER.info("Rituel r\u00e9ussi : {}", (Object)this.currentRitual.getClass().getSimpleName());
        } else {
            this.currentRitual.onFailure(world, pos, this, player);
            TheAlchemistsTouch.LOGGER.info("Rituel \u00e9chou\u00e9 : {} ", (Object)this.currentRitual.getClass().getSimpleName());
        }
        world.method_20290(1503, pos, 0);
        if (this.getBlood() <= 0) {
            world.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
            world.method_8650(pos, false);
            world.method_60511(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (class_6880)class_3417.field_15152, class_3419.field_15245, 0.8f, 1.2f);
        }
        this.isPerforming = false;
        this.currentRitual = null;
        this.ritualTicks = 0;
        this.method_5431();
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public class_1799 getIngredient() {
        return (class_1799)this.inventory.getFirst();
    }

    @Override
    public boolean method_5442() {
        return ImplementedInventory.super.method_5442() || ((class_1799)this.inventory.getFirst()).method_7960();
    }

    public int getBlood() {
        return this.bloodAmount;
    }

    public void setBlood(int amount) {
        this.bloodAmount = Math.min(amount, 300);
        this.method_5431();
    }

    public void addBlood(int amount) {
        this.setBlood(this.bloodAmount + amount);
    }

    public int getMaxBlood() {
        return 300;
    }

    public class_2350 getFacing() {
        return this.facing;
    }

    public void setFacing(class_2350 facing) {
        this.facing = facing;
        this.method_5431();
    }

    @Override
    public void method_5431() {
        Object payload;
        class_3218 serverWorld;
        super.method_5431();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            serverWorld = (class_3218)class_19372;
            payload = new RitualCircleSyncS2CPayload(this.field_11867, (class_1799)this.inventory.getFirst(), this.bloodAmount);
            for (class_3222 player : PlayerLookup.tracking((class_3218)serverWorld, (class_2338)this.field_11867)) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
            }
        }
        if (!this.isPerforming && (payload = this.field_11863) instanceof class_3218) {
            class_1657 nearest;
            serverWorld = (class_3218)payload;
            if (!((class_1799)this.inventory.getFirst()).method_7960() && (nearest = serverWorld.method_18459((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), 6.0, false)) != null) {
                this.tryTriggerRitual(serverWorld, this, nearest);
            }
        }
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        class_1262.method_5426((class_11372)view, this.inventory);
        view.method_71465("Blood", this.bloodAmount);
        view.method_71465("Facing", this.facing.method_10146());
        view.method_71472("IsPerforming", this.isPerforming);
        if (this.currentRitual != null) {
            class_2960 id = RitualRegistry.RITUAL.method_10221((Object)this.currentRitual);
            if (id != null) {
                view.method_71469("CurrentRitual", id.toString());
            }
            view.method_71465("RitualTicks", this.ritualTicks);
        }
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        class_1262.method_5429((class_11368)view, this.inventory);
        this.bloodAmount = view.method_71424("Blood", 0);
        this.facing = class_2350.method_10143((int)view.method_71424("Facing", 0));
        this.isPerforming = view.method_71433("IsPerforming", false);
        if (this.isPerforming) {
            String id = view.method_71428("CurrentRitual", "");
            this.currentRitual = (Ritual)RitualRegistry.RITUAL.method_63535(class_2960.method_12829((String)id));
            this.ritualTicks = view.method_71424("RitualTicks", 0);
        }
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.field_11867;
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Ritual Circle");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new RitualCircleScreenHandler(syncId, playerInventory, this.field_11867);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

