/*
 * Decompiled with CFR 0.152.
 */
package com.matibi.thealchemiststouch.client.modmenu.config;

import com.matibi.thealchemiststouch.client.modmenu.config.ModConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_11909;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public final class MyConfigScreen
extends class_437 {
    private final class_437 parent;
    private class_342 search;
    private final List<Row> rows = new ArrayList<Row>();
    private int contentHeight;
    private int scroll;
    private int listTop;
    private int listBottom;
    private int listLeft;
    private int listRight;
    private boolean draggingBar = false;
    private int dragOffsetY = 0;
    private int lastBarY = 0;
    private int lastBarH = 0;
    private boolean hasScrollbar = false;

    public MyConfigScreen(class_437 parent) {
        super(class_2561.method_30163((String)"The Alchemist's Touch \u2014 Potions"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.listTop = 56;
        this.listBottom = this.field_22790 - 40;
        this.listLeft = 16;
        this.listRight = this.field_22789 - 16;
        this.search = new class_342(this.field_22793, this.listLeft, 30, this.field_22789 - 32, 16, class_2561.method_30163((String)"Search"));
        this.search.method_47404(class_2561.method_30163((String)"Rechercher par nom\u2026"));
        this.search.method_1863(s -> this.rebuild());
        this.method_25429((class_364)this.search);
        this.method_48265((class_364)this.search);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Done"), b -> this.method_25419()).method_46434(this.field_22789 / 2 - 40, this.field_22790 - 28, 80, 20).method_46431());
        this.rebuild();
    }

    private static String displayNameOf(class_6880<class_1842> entry) {
        class_1799 stack = class_1844.method_57400((class_1792)class_1802.field_8574, entry);
        return stack.method_7964().getString();
    }

    private void rebuild() {
        this.rows.clear();
        String q = this.search.method_1882().trim().toLowerCase(Locale.ROOT);
        ArrayList all = new ArrayList();
        class_7923.field_41179.method_40295().forEach(all::add);
        LinkedHashMap<class_2960, class_6880> byBase = new LinkedHashMap<class_2960, class_6880>();
        for (class_6880 e : all) {
            class_2960 id = class_2960.method_60654((String)e.method_55840());
            class_2960 class_29602 = ModConfig.basePotionId(id);
            class_6880 current = (class_6880)byBase.get(class_29602);
            if (current != null && !id.equals((Object)class_29602)) continue;
            byBase.put(class_29602, e);
        }
        ArrayList families = new ArrayList(byBase.entrySet());
        families.sort(Comparator.comparing(en -> MyConfigScreen.displayNameOf((class_6880<class_1842>)((class_6880)en.getValue())).toLowerCase(Locale.ROOT)).thenComparing(en -> ((class_2960)en.getKey()).toString()));
        int y = 0;
        for (Map.Entry entry : families) {
            class_2960 baseId = (class_2960)entry.getKey();
            class_6880 entry2 = (class_6880)entry.getValue();
            String name = MyConfigScreen.displayNameOf((class_6880<class_1842>)entry2);
            String nameLower = name.toLowerCase(Locale.ROOT);
            if (!q.isEmpty() && !nameLower.contains(q) || ModConfig.PROTECTED_POTIONS.contains(entry2)) continue;
            boolean disabledFamily = ModConfig.DISABLED_POTIONS.contains(baseId);
            boolean enabled = !disabledFamily;
            this.rows.add(new Row((class_6880<class_1842>)entry2, baseId, name, nameLower, y, enabled));
            y += 20;
        }
        this.contentHeight = y;
        this.clampScroll();
    }

    private void clampScroll() {
        int visible = this.listBottom - this.listTop;
        int max = Math.max(0, this.contentHeight - visible);
        this.scroll = Math.max(0, Math.min(this.scroll, max));
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (mouseY >= (double)this.listTop && mouseY <= (double)this.listBottom && mouseX >= (double)this.listLeft && mouseX <= (double)this.listRight) {
            this.scroll -= (int)(verticalAmount * 20.0);
            this.clampScroll();
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25402(class_11909 click, boolean dragged) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (button == 0 && mouseY >= (double)this.listTop && mouseY <= (double)this.listBottom && mouseX >= (double)this.listLeft && mouseX <= (double)this.listRight) {
            int yStart = this.listTop - this.scroll;
            for (Row r : this.rows) {
                int y = yStart + r.y;
                int boxX = this.listLeft + 6;
                int boxY = y + 2;
                if (!(mouseX >= (double)boxX) || !(mouseX < (double)(boxX + 12)) || !(mouseY >= (double)boxY) || !(mouseY < (double)(boxY + 12))) continue;
                boolean bl = r.enabled = !r.enabled;
                if (r.enabled) {
                    ModConfig.DISABLED_POTIONS.remove(r.baseId);
                } else {
                    ModConfig.DISABLED_POTIONS.add(r.baseId);
                }
                ModConfig.save();
                return true;
            }
        }
        if (button == 0 && this.hasScrollbar) {
            int barX1 = this.listRight - 6;
            int barX2 = this.listRight - 2;
            if (mouseX >= (double)barX1 && mouseX <= (double)barX2 && mouseY >= (double)this.listTop && mouseY <= (double)this.listBottom) {
                this.draggingBar = true;
                if (mouseY >= (double)this.lastBarY && mouseY <= (double)(this.lastBarY + this.lastBarH)) {
                    this.dragOffsetY = (int)(mouseY - (double)this.lastBarY);
                } else {
                    this.dragOffsetY = this.lastBarH / 2;
                    this.updateScrollFromMouse((int)mouseY);
                }
                return true;
            }
        }
        return super.method_25402(click, dragged);
    }

    public boolean method_25403(class_11909 click, double dx, double dy) {
        double mouseY = click.comp_4799();
        if (this.draggingBar) {
            this.updateScrollFromMouse((int)mouseY);
            return true;
        }
        return super.method_25403(click, dx, dy);
    }

    public boolean method_25406(class_11909 click) {
        int button = click.method_74245();
        if (button == 0 && this.draggingBar) {
            this.draggingBar = false;
            return true;
        }
        return super.method_25406(click);
    }

    private void updateScrollFromMouse(int mouseY) {
        int trackHeight = this.listBottom - this.listTop;
        int maxScroll = Math.max(0, this.contentHeight - trackHeight);
        if (maxScroll == 0) {
            this.scroll = 0;
            return;
        }
        int minY = this.listTop;
        int thumbH = Math.max(20, (int)((float)trackHeight * ((float)trackHeight / (float)this.contentHeight)));
        int thumbY = mouseY - this.dragOffsetY;
        int maxY = minY + trackHeight - thumbH;
        thumbY = Math.max(minY, Math.min(thumbY, maxY));
        float t = (float)(thumbY - minY) / (float)(trackHeight - thumbH);
        this.scroll = (int)(t * (float)maxScroll);
        this.clampScroll();
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        ctx.method_25294(0, 0, this.field_22789, this.field_22790, -1879048192);
        ctx.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, -1);
        ctx.method_25294(this.listLeft - 2, this.listTop - 2, this.listRight + 2, this.listBottom + 2, 0x40FFFFFF);
        ctx.method_25294(this.listLeft, this.listTop, this.listRight, this.listBottom, Integer.MIN_VALUE);
        super.method_25394(ctx, mouseX, mouseY, delta);
        this.search.method_25394(ctx, mouseX, mouseY, delta);
        ctx.method_44379(this.listLeft, this.listTop, this.listRight, this.listBottom);
        int yStart = this.listTop - this.scroll;
        for (Row r : this.rows) {
            int y = yStart + r.y;
            if (y < this.listTop - 20 || y > this.listBottom) continue;
            int boxX = this.listLeft + 6;
            int boxY = y + 2;
            if (mouseX >= this.listLeft && mouseX <= this.listRight && mouseY >= y && mouseY <= y + 18) {
                ctx.method_25294(this.listLeft + 1, y, this.listRight - 1, y + 18, 0x30FFFFFF);
            }
            ctx.method_25294(boxX, boxY, boxX + 12, boxY + 12, -14671840);
            if (r.enabled) {
                ctx.method_25294(boxX + 2, boxY + 2, boxX + 10, boxY + 10, -10436512);
            }
            int textX = boxX + 16;
            int nameColor = r.enabled ? -1 : -5592406;
            ctx.method_25303(this.field_22793, r.name, textX, y + 5, nameColor);
        }
        ctx.method_44380();
        int visible = this.listBottom - this.listTop;
        boolean bl = this.hasScrollbar = this.contentHeight > visible;
        if (this.hasScrollbar) {
            float ratio = (float)visible / (float)this.contentHeight;
            int barH = Math.max(20, (int)(ratio * (float)visible));
            int maxScroll = this.contentHeight - visible;
            int barY = this.listTop + (int)((float)this.scroll / (float)maxScroll * (float)(visible - barH));
            int barX1 = this.listRight - 6;
            int barX2 = this.listRight - 2;
            ctx.method_25294(barX1, this.listTop, barX2, this.listBottom, 0x40000000);
            ctx.method_25294(barX1, barY, barX2, barY + barH, this.draggingBar ? -1056964609 : -2130706433);
            this.lastBarY = barY;
            this.lastBarH = barH;
        } else {
            this.lastBarH = 0;
            this.lastBarY = 0;
        }
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private static final class Row {
        final class_6880<class_1842> entry;
        final class_2960 baseId;
        final String name;
        final String nameLower;
        final int y;
        boolean enabled;

        Row(class_6880<class_1842> entry, class_2960 baseId, String name, String nameLower, int y, boolean enabled) {
            this.entry = entry;
            this.baseId = baseId;
            this.name = name;
            this.nameLower = nameLower;
            this.y = y;
            this.enabled = enabled;
        }
    }
}

