/*
 * Decompiled with CFR 0.152.
 */
package com.matibi.thealchemiststouch.recipe;

import com.matibi.thealchemiststouch.datacomponent.ImbuedEffect;
import com.matibi.thealchemiststouch.datacomponent.ModDataComponents;
import com.matibi.thealchemiststouch.recipe.ModRecipeSerializer;
import com.matibi.thealchemiststouch.util.ModTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9694;

public class ImbuedEffectRecipe
extends class_1852 {
    private static final int DEFAULT_HITS = 10;

    public ImbuedEffectRecipe(class_7710 category) {
        super(category);
    }

    public boolean matches(class_9694 input, class_1937 world) {
        class_1799 weapon = class_1799.field_8037;
        class_1799 potion = class_1799.field_8037;
        for (int y = 0; y < input.method_59992(); ++y) {
            for (int x = 0; x < input.method_59991(); ++x) {
                class_1799 stack = input.method_59985(x, y);
                if (stack.method_7960()) continue;
                if (this.isPotionItem(stack)) {
                    if (!potion.method_7960()) {
                        return false;
                    }
                    potion = stack;
                    continue;
                }
                if (this.isWeapon(stack)) {
                    if (!weapon.method_7960()) {
                        return false;
                    }
                    weapon = stack;
                    continue;
                }
                return false;
            }
        }
        if (weapon.method_7960() || potion.method_7960()) {
            return false;
        }
        if (weapon.method_57826(ModDataComponents.IMBUED_EFFECT) || !Objects.requireNonNull((class_9304)weapon.method_58694(class_9334.field_49633)).method_57543()) {
            return false;
        }
        List<class_1293> effects = ImbuedEffectRecipe.getEffectList(potion);
        return !effects.isEmpty();
    }

    private boolean isPotionItem(class_1799 stack) {
        return stack.method_31574(class_1802.field_8574) || stack.method_31574(class_1802.field_8436) || stack.method_31574(class_1802.field_8150);
    }

    private boolean isWeapon(class_1799 stack) {
        return stack.method_31573(ModTags.Items.IMBUEABLE_WEAPONS);
    }

    public class_1799 craft(class_9694 input, class_7225.class_7874 lookup) {
        class_1799 weapon = class_1799.field_8037;
        class_1799 potion = class_1799.field_8037;
        for (int i = 0; i < input.method_59983(); ++i) {
            class_1799 stack = input.method_59984(i);
            if (stack.method_7960()) continue;
            if (this.isPotionItem(stack)) {
                potion = stack;
                continue;
            }
            if (!this.isWeapon(stack)) continue;
            weapon = stack;
        }
        List<class_1293> effects = ImbuedEffectRecipe.getEffectList(potion);
        class_1293 chosen = effects.getFirst();
        class_1799 result = weapon.method_7972();
        result.method_7939(1);
        int hits = 10 + chosen.method_5584() / 1200 * 2;
        result.method_57379(ModDataComponents.IMBUED_EFFECT, (Object)new ImbuedEffect((class_6880<class_1291>)chosen.method_5579(), hits, chosen.method_5578()));
        result.method_57379(class_9334.field_49641, (Object)true);
        return result;
    }

    public class_1865<ImbuedEffectRecipe> method_8119() {
        return ModRecipeSerializer.IMBUED_EFFECT;
    }

    public static List<class_1293> getEffectList(class_1799 potion) {
        ArrayList<class_1293> effects = new ArrayList<class_1293>();
        class_1844 component = (class_1844)potion.method_58694(class_9334.field_49651);
        if (component != null) {
            component.method_57397().forEach(effects::add);
        }
        return effects;
    }
}

