/*
 * Decompiled with CFR 0.152.
 */
package com.matibi.thealchemiststouch.util;

import com.matibi.thealchemiststouch.TheAlchemistsTouch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_3218;

public final class TickUtil {
    private static final Map<class_3218, List<ScheduledTask>> TASKS = new HashMap<class_3218, List<ScheduledTask>>();

    public static void runLater(class_3218 world, int ticks, Runnable action) {
        TASKS.computeIfAbsent(world, w -> new ArrayList()).add(new ScheduledTask(ticks, action));
    }

    static {
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            List<ScheduledTask> list = TASKS.get(world);
            if (list == null) {
                return;
            }
            Iterator<ScheduledTask> it = list.iterator();
            while (it.hasNext()) {
                ScheduledTask task = it.next();
                --task.ticks;
                if (task.ticks > 0) continue;
                try {
                    task.action.run();
                }
                catch (Exception e) {
                    TheAlchemistsTouch.LOGGER.info("Error in delayed task {}", (Object)String.valueOf(e));
                }
                it.remove();
            }
        });
    }

    private static final class ScheduledTask {
        int ticks;
        final Runnable action;

        ScheduledTask(int ticks, Runnable action) {
            this.ticks = ticks;
            this.action = action;
        }
    }
}

