/*
 * Decompiled with CFR 0.152.
 */
package com.juaanp.seamlesstrading;

import com.juaanp.seamlesstrading.CommonClass;
import com.juaanp.seamlesstrading.client.ConfigScreenBase;
import com.juaanp.seamlesstrading.platform.NeoForgePlatformHelper;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="seamlesstrading")
public class SeamlessTradingNeoForge {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ModContainer modContainer;

    public SeamlessTradingNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        this.modContainer = modContainer;
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NeoForgePlatformHelper.SPEC);
        CommonClass.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("SeamlessTrading initializing...");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("SeamlessTrading server starting...");
    }

    @EventBusSubscriber(modid="seamlesstrading", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("SeamlessTrading client setup...");
            ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (mc, screen) -> new ConfigScreenBase(screen, Minecraft.getInstance().options));
        }
    }
}

