/*
 * Decompiled with CFR 0.152.
 */
package com.juaanp.seamlesstrading.client;

import com.juaanp.seamlesstrading.config.CommonConfig;
import com.juaanp.seamlesstrading.config.ConfigHelper;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ConfigScreenBase
extends OptionsSubScreen {
    private static final Component TITLE = Component.translatable((String)"seamlesstrading.config.title");
    private static final Component RESET = Component.translatable((String)"seamlesstrading.config.reset");
    protected final Options options;
    protected Button resetButton;
    protected final Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(120).build();
    private Boolean lastScrollNewOffers = null;

    public ConfigScreenBase(Screen lastScreen, Options options) {
        super(lastScreen, options, TITLE);
        this.options = options;
    }

    protected void addFooter() {
        LinearLayout linearLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        if (this.resetButton != null) {
            linearLayout.addChild((LayoutElement)this.resetButton);
            linearLayout.addChild((LayoutElement)this.doneButton);
        } else {
            super.addFooter();
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.setResetButtonState(this.isAnyNonDefault());
        super.render(graphics, mouseX, mouseY, partialTick);
    }

    protected void addOptions() {
        if (this.resetButton == null) {
            this.createResetButton();
        }
        this.initializeTrackingFields();
        OptionInstance scrollNewOffers = OptionInstance.createBoolean((String)"seamlesstrading.config.scrollNewOffers", (boolean)this.getScrollNewOffers(), this::setScrollNewOffers);
        this.list.addBig(scrollNewOffers);
    }

    protected boolean isAnyNonDefault() {
        return this.getScrollNewOffers() != CommonConfig.getDefaultScrollNewOffers();
    }

    private void createResetButton() {
        this.resetButton = Button.builder((Component)RESET, button -> this.resetToDefaults()).width(120).build();
    }

    protected void setResetButtonState(boolean state) {
        if (this.resetButton != null) {
            this.resetButton.active = state;
        }
    }

    private void resetToDefaults() {
        this.setScrollNewOffers(CommonConfig.getDefaultScrollNewOffers());
        this.saveConfig();
        this.minecraft.setScreen(this.lastScreen);
        this.minecraft.setScreen((Screen)new ConfigScreenBase(this.lastScreen, this.options));
    }

    private void initializeTrackingFields() {
        this.lastScrollNewOffers = this.getScrollNewOffers();
    }

    protected boolean getScrollNewOffers() {
        return CommonConfig.getInstance().isScrollNewOffers();
    }

    protected void setScrollNewOffers(boolean enabled) {
        CommonConfig.getInstance().setScrollNewOffers(enabled);
    }

    protected void saveConfig() {
        ConfigHelper.save();
    }

    public void onClose() {
        this.saveConfig();
        super.onClose();
    }

    public void removed() {
        this.saveConfig();
        super.removed();
    }

    private static class EmptyWidget
    extends AbstractWidget {
        public EmptyWidget(int width, int height) {
            super(0, 0, width, height, (Component)Component.empty());
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

