/*
 * Decompiled with CFR 0.152.
 */
package com.juaanp.seamlesstrading.client;

import com.juaanp.seamlesstrading.config.CommonConfig;
import com.juaanp.seamlesstrading.config.ConfigHelper;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ConfigScreenBase
extends Screen {
    private static final Component TITLE = Component.translatable((String)"seamlesstrading.config.title");
    private static final Component RESET = Component.translatable((String)"seamlesstrading.config.reset");
    protected final Screen lastScreen;
    protected final Options options;
    protected Button resetButton;
    protected Button doneButton;
    protected OptionsList list;
    private Boolean lastScrollNewOffers = null;

    public ConfigScreenBase(Screen lastScreen, Options options) {
        super(TITLE);
        this.lastScreen = lastScreen;
        this.options = options;
    }

    protected void init() {
        this.list = new OptionsList(this.minecraft, this.width, this.height - 64, 32, this.height - 32);
        this.resetButton = Button.builder((Component)RESET, button -> this.resetToDefaults()).pos(this.width / 2 - 155, this.height - 29).size(150, 20).build();
        this.doneButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).pos(this.width / 2 + 5, this.height - 29).size(150, 20).build();
        this.addRenderableWidget((GuiEventListener)this.resetButton);
        this.addRenderableWidget((GuiEventListener)this.doneButton);
        this.addOptions();
        this.addRenderableWidget((GuiEventListener)this.list);
        this.initializeTrackingFields();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderDirtBackground(graphics);
        super.render(graphics, mouseX, mouseY, partialTick);
        this.list.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 5, 0xFFFFFF);
        this.setResetButtonState(this.isAnyNonDefault());
    }

    protected void addOptions() {
        OptionInstance scrollNewOffers = OptionInstance.createBoolean((String)"seamlesstrading.config.scrollNewOffers", (boolean)this.getScrollNewOffers(), this::setScrollNewOffers);
        this.list.addBig(scrollNewOffers);
    }

    protected void setResetButtonState(boolean state) {
        if (this.resetButton != null) {
            this.resetButton.active = state;
        }
    }

    protected boolean isAnyNonDefault() {
        return this.getScrollNewOffers() != CommonConfig.getDefaultScrollNewOffers();
    }

    private void resetToDefaults() {
        this.setScrollNewOffers(CommonConfig.getDefaultScrollNewOffers());
        this.saveConfig();
        this.minecraft.setScreen(this.lastScreen);
        this.minecraft.setScreen((Screen)new ConfigScreenBase(this.lastScreen, this.options));
    }

    private void initializeTrackingFields() {
        this.lastScrollNewOffers = this.getScrollNewOffers();
    }

    protected boolean getScrollNewOffers() {
        return CommonConfig.getInstance().isScrollNewOffers();
    }

    protected void setScrollNewOffers(boolean enabled) {
        CommonConfig.getInstance().setScrollNewOffers(enabled);
    }

    protected void saveConfig() {
        ConfigHelper.save();
    }

    public void onClose() {
        this.saveConfig();
        this.minecraft.setScreen(this.lastScreen);
    }

    public void removed() {
        this.saveConfig();
        super.removed();
    }

    private static class EmptyWidget
    extends AbstractWidget {
        public EmptyWidget(int width, int height) {
            super(0, 0, width, height, (Component)Component.empty());
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

