/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.easycoinsystem.block;

import io.netty.buffer.Unpooled;
import net.mcreator.easycoinsystem.block.entity.ATMBlockEntity;
import net.mcreator.easycoinsystem.procedures.ATMUpdateTickProcedure;
import net.mcreator.easycoinsystem.world.inventory.ATMGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ATMBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public ATMBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(8.0f, 15.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)ATMBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ATMBlock.box((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)27.0, (double)2.0), ATMBlock.box((double)0.0, (double)16.0, (double)2.0, (double)16.0, (double)22.0, (double)4.0), ATMBlock.box((double)0.0, (double)16.0, (double)4.0, (double)16.0, (double)17.0, (double)5.0), ATMBlock.box((double)0.0, (double)16.0, (double)12.0, (double)16.0, (double)17.0, (double)16.0), ATMBlock.box((double)0.0, (double)16.0, (double)5.0, (double)16.0, (double)32.0, (double)13.0), ATMBlock.box((double)0.0, (double)28.0, (double)0.0, (double)16.0, (double)31.0, (double)7.0), ATMBlock.box((double)11.0, (double)16.5, (double)13.0, (double)13.0, (double)17.5, (double)15.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)ATMBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ATMBlock.box((double)0.0, (double)16.0, (double)14.0, (double)16.0, (double)27.0, (double)16.0), ATMBlock.box((double)0.0, (double)16.0, (double)12.0, (double)16.0, (double)22.0, (double)14.0), ATMBlock.box((double)0.0, (double)16.0, (double)11.0, (double)16.0, (double)17.0, (double)12.0), ATMBlock.box((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)17.0, (double)4.0), ATMBlock.box((double)0.0, (double)16.0, (double)3.0, (double)16.0, (double)32.0, (double)11.0), ATMBlock.box((double)0.0, (double)28.0, (double)9.0, (double)16.0, (double)31.0, (double)16.0), ATMBlock.box((double)3.0, (double)16.5, (double)1.0, (double)5.0, (double)17.5, (double)3.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)ATMBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ATMBlock.box((double)0.0, (double)16.0, (double)0.0, (double)2.0, (double)27.0, (double)16.0), ATMBlock.box((double)2.0, (double)16.0, (double)0.0, (double)4.0, (double)22.0, (double)16.0), ATMBlock.box((double)4.0, (double)16.0, (double)0.0, (double)5.0, (double)17.0, (double)16.0), ATMBlock.box((double)12.0, (double)16.0, (double)0.0, (double)16.0, (double)17.0, (double)16.0), ATMBlock.box((double)5.0, (double)16.0, (double)0.0, (double)13.0, (double)32.0, (double)16.0), ATMBlock.box((double)0.0, (double)28.0, (double)0.0, (double)7.0, (double)31.0, (double)16.0), ATMBlock.box((double)13.0, (double)16.5, (double)3.0, (double)15.0, (double)17.5, (double)5.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)ATMBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ATMBlock.box((double)14.0, (double)16.0, (double)0.0, (double)16.0, (double)27.0, (double)16.0), ATMBlock.box((double)12.0, (double)16.0, (double)0.0, (double)14.0, (double)22.0, (double)16.0), ATMBlock.box((double)11.0, (double)16.0, (double)0.0, (double)12.0, (double)17.0, (double)16.0), ATMBlock.box((double)0.0, (double)16.0, (double)0.0, (double)4.0, (double)17.0, (double)16.0), ATMBlock.box((double)3.0, (double)16.0, (double)0.0, (double)11.0, (double)32.0, (double)16.0), ATMBlock.box((double)9.0, (double)28.0, (double)0.0, (double)16.0, (double)31.0, (double)16.0), ATMBlock.box((double)1.0, (double)16.5, (double)11.0, (double)3.0, (double)17.5, (double)13.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 10);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        ATMUpdateTickProcedure.execute();
        world.scheduleTick(pos, (Block)this, 10);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"classic ATM");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new ATMGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ATMBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof ATMBlockEntity) {
                ATMBlockEntity be = (ATMBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }
}

