/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.easycoinsystem.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mcreator.easycoinsystem.init.EasyCoinSystemModScreens;
import net.mcreator.easycoinsystem.network.SetPasswordButtonMessage;
import net.mcreator.easycoinsystem.world.inventory.SetPasswordMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class SetPasswordScreen
extends AbstractContainerScreen<SetPasswordMenu>
implements EasyCoinSystemModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private EditBox password;
    private Button button_set_password;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"easy_coin_system:textures/screens/set_password.png");

    public SetPasswordScreen(SetPasswordMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 86;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("password")) {
                this.password.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.password.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.password.isFocused()) {
            return this.password.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String passwordValue = this.password.getValue();
        super.resize(minecraft, width, height);
        this.password.setValue(passwordValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.easy_coin_system.set_password.label_save"), 77, 5, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.easy_coin_system.set_password.label_please_choose_your_password"), 14, 17, -12829636, false);
    }

    public void init() {
        super.init();
        this.password = new EditBox(this.font, this.leftPos + 28, this.topPos + 31, 118, 18, (Component)Component.translatable((String)"gui.easy_coin_system.set_password.password"));
        this.password.setMaxLength(8192);
        this.password.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((SetPasswordMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "password", content, false);
            }
        });
        this.addWidget((GuiEventListener)this.password);
        this.button_set_password = Button.builder((Component)Component.translatable((String)"gui.easy_coin_system.set_password.button_set_password"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new SetPasswordButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SetPasswordButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 43, this.topPos + 57, 87, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_set_password);
    }
}

