/*
 * Decompiled with CFR 0.152.
 */
package settingdust.kinecraft.serialization.codec.internal;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialInfo;
import kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import settingdust.kinecraft.serialization.codec.internal.decoder.DynamicDecoder;
import settingdust.kinecraft.serialization.codec.internal.encoder.DynamicEncoder;
import settingdust.kinecraft.util.DataResultExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002:\u0001\"B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0016\u001a\u00020\f\"\b\b\u0001\u0010\u0014*\u00020\u00132\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u00152\u0006\u0010\u000b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\u0019\u001a\u00028\u0000\"\b\b\u0001\u0010\u0014*\u00020\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001bR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001cR\u001a\u0010\u001e\u001a\u00020\u001d8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006#"}, d2={"Lsettingdust/kinecraft/serialization/codec/internal/CodecSerializerAdapter;", "T", "Lkotlinx/serialization/KSerializer;", "Lcom/mojang/serialization/Codec;", "codec", "", "typeName", "<init>", "(Lcom/mojang/serialization/Codec;Ljava/lang/String;)V", "Lkotlinx/serialization/encoding/Encoder;", "encoder", "value", "", "serialize", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Object;)V", "Lkotlinx/serialization/encoding/Decoder;", "decoder", "deserialize", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Object;", "", "A", "Lsettingdust/kinecraft/serialization/codec/internal/encoder/DynamicEncoder;", "serializeToDynamic", "(Lsettingdust/kinecraft/serialization/codec/internal/encoder/DynamicEncoder;Ljava/lang/Object;)V", "Lsettingdust/kinecraft/serialization/codec/internal/decoder/DynamicDecoder;", "deserializeFromDynamic", "(Lsettingdust/kinecraft/serialization/codec/internal/decoder/DynamicDecoder;)Ljava/lang/Object;", "Lcom/mojang/serialization/Codec;", "Ljava/lang/String;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "Marker", "kinecraft_fabric121"})
public final class CodecSerializerAdapter<T>
implements KSerializer<T> {
    @NotNull
    private final Codec<T> codec;
    @NotNull
    private final String typeName;
    @NotNull
    private final SerialDescriptor descriptor;

    public CodecSerializerAdapter(@NotNull Codec<T> codec, @NotNull String typeName) {
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        this.codec = codec;
        this.typeName = typeName;
        this.descriptor = SerialDescriptorsKt.buildClassSerialDescriptor((String)this.typeName, (SerialDescriptor[])new SerialDescriptor[0], CodecSerializerAdapter::descriptor$lambda$0);
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void serialize(@NotNull Encoder encoder, T value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        if (!(encoder instanceof DynamicEncoder)) {
            throw new UnsupportedOperationException("Codec serializers can only be used in Dynamic serialization");
        }
        this.serializeToDynamic((DynamicEncoder)encoder, value);
    }

    public T deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        if (!(decoder instanceof DynamicDecoder)) {
            throw new UnsupportedOperationException("Codec serializers can only be used in Dynamic serialization");
        }
        return this.deserializeFromDynamic((DynamicDecoder)decoder);
    }

    private final <A> void serializeToDynamic(DynamicEncoder<A> encoder, T value) {
        DataResult dataResult = this.codec.encode(value, encoder.getOps(), encoder.getOps().empty());
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"encode(...)");
        Object r = DataResultExtension.Companion.unwrap(dataResult);
        Intrinsics.checkNotNullExpressionValue(r, (String)"unwrap(...)");
        encoder.encodeExternal(r);
    }

    private final <A> T deserializeFromDynamic(DynamicDecoder<A> decoder) {
        return decoder.decodeExternal(this.codec, this.typeName);
    }

    private static final Unit descriptor$lambda$0(ClassSerialDescriptorBuilder $this$buildClassSerialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$buildClassSerialDescriptor, (String)"$this$buildClassSerialDescriptor");
        $this$buildClassSerialDescriptor.setAnnotations(CollectionsKt.listOf((Object)new Marker(){

            public final boolean equals(@Nullable Object other) {
                if (!(other instanceof Marker)) {
                    return false;
                }
                Marker cfr_ignored_0 = (Marker)other;
                return true;
            }

            public final int hashCode() {
                return 0;
            }

            @NotNull
            public final String toString() {
                return "@settingdust.kinecraft.serialization.codec.internal.CodecSerializerAdapter.Marker()";
            }

            public final /* synthetic */ Class annotationType() {
                return Marker.class;
            }
        }));
        return Unit.INSTANCE;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0003\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lsettingdust/kinecraft/serialization/codec/internal/CodecSerializerAdapter$Marker;", "", "<init>", "()V", "kinecraft_fabric121"})
    @SerialInfo
    public static @interface Marker {

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class Impl
        implements Marker {
        }
    }
}

