/*
 * Decompiled with CFR 0.152.
 */
package settingdust.kinecraft.serialization.codec.internal.decoder;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import settingdust.kinecraft.serialization.codec.ExtendedDynamicOps;
import settingdust.kinecraft.serialization.codec.internal.ElementOptions;
import settingdust.kinecraft.serialization.codec.internal.SerializationConfig;
import settingdust.kinecraft.serialization.codec.internal.decoder.ClassState;
import settingdust.kinecraft.serialization.codec.internal.decoder.CollectionState;
import settingdust.kinecraft.serialization.codec.internal.decoder.DecoderState;
import settingdust.kinecraft.serialization.codec.internal.decoder.DynamicDecoder;
import settingdust.kinecraft.serialization.codec.internal.decoder.EntryListMapState;
import settingdust.kinecraft.serialization.codec.internal.decoder.InlineState;
import settingdust.kinecraft.serialization.codec.internal.decoder.ListState;
import settingdust.kinecraft.serialization.codec.internal.decoder.NullableState;
import settingdust.kinecraft.serialization.codec.internal.decoder.ObjectState;
import settingdust.kinecraft.serialization.codec.internal.decoder.PolymorphicState;
import settingdust.kinecraft.serialization.codec.internal.decoder.RegularMapState;
import settingdust.kinecraft.serialization.codec.internal.decoder.RootState;
import settingdust.kinecraft.serialization.codec.internal.util.AnnotationUtilKt;
import settingdust.kinecraft.serialization.codec.internal.util.DataUtilKt;
import settingdust.kinecraft.serialization.codec.internal.util.ValidationUtilKt;
import settingdust.kinecraft.serialization.codec.options.CodecOptions;
import settingdust.kinecraft.util.DataResultExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003B-\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0010\u001a\u00020\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u000fH\u0082\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b#\u0010 J\u0017\u0010%\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010'\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b'\u0010(J#\u0010+\u001a\u00028\u0001\"\u0004\b\u0001\u0010\u00022\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00010)H\u0016\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010.\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b.\u0010/J\u000f\u00100\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b0\u0010\"J\u0011\u00102\u001a\u0004\u0018\u000101H\u0016\u00a2\u0006\u0004\b2\u00103J\u0017\u00105\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b5\u0010 J)\u00107\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0006\u001a\u00028\u00002\u0006\u00104\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b7\u00108J)\u0010:\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0006\u001a\u00028\u00002\u0006\u00104\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b:\u00108J)\u0010@\u001a\u00028\u0001\"\u0004\b\u0001\u0010;2\f\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00010<2\u0006\u0010?\u001a\u00020>\u00a2\u0006\u0004\b@\u0010AJJ\u0010G\u001a\u00028\u0001\"\b\b\u0001\u0010B*\u00020\u00012\u0018\u0010E\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010D0C2\u0014\u0010F\u001a\u0010\u0012\u0004\u0012\u00020>\u0012\u0006\u0012\u0004\u0018\u00018\u00010CH\u0082\b\u00a2\u0006\u0004\bG\u0010HJF\u0010K\u001a\u00028\u0001\"\b\b\u0001\u0010B*\u00020\u00012\u0014\b\b\u0010J\u001a\u000e\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00028\u00010C2\u0014\u0010F\u001a\u0010\u0012\u0004\u0012\u00020>\u0012\u0006\u0012\u0004\u0018\u00018\u00010CH\u0082\b\u00a2\u0006\u0004\bK\u0010HJ\u000f\u0010L\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\bL\u0010\"J\u000f\u0010N\u001a\u00020MH\u0016\u00a2\u0006\u0004\bN\u0010OJ\u000f\u0010Q\u001a\u00020PH\u0016\u00a2\u0006\u0004\bQ\u0010RJ\u000f\u0010S\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\bS\u0010TJ\u000f\u0010V\u001a\u00020UH\u0016\u00a2\u0006\u0004\bV\u0010WJ\u000f\u0010Y\u001a\u00020XH\u0016\u00a2\u0006\u0004\bY\u0010ZJ\u000f\u0010\\\u001a\u00020[H\u0016\u00a2\u0006\u0004\b\\\u0010]J\u000f\u0010_\u001a\u00020^H\u0016\u00a2\u0006\u0004\b_\u0010`J\u000f\u0010a\u001a\u00020>H\u0016\u00a2\u0006\u0004\ba\u0010bJ\r\u0010c\u001a\u00020>\u00a2\u0006\u0004\bc\u0010bR\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010d\u001a\u0004\be\u0010fR\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010gR\u001a\u0010\n\u001a\u00020\t8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\n\u0010h\u001a\u0004\bi\u0010jR\u001a\u0010l\u001a\b\u0012\u0004\u0012\u00028\u00000k8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bl\u0010mR\u001a\u0010o\u001a\b\u0012\u0004\u0012\u00028\u00000n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bo\u0010pR \u0010r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0q8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\br\u0010sR\u001a\u0010v\u001a\b\u0012\u0004\u0012\u00028\u00000\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bt\u0010u\u00a8\u0006w"}, d2={"Lsettingdust/kinecraft/serialization/codec/internal/decoder/DynamicDecoder;", "", "T", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lcom/mojang/serialization/DynamicOps;", "ops", "input", "Lsettingdust/kinecraft/serialization/codec/options/CodecOptions;", "options", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "<init>", "(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;Lsettingdust/kinecraft/serialization/codec/options/CodecOptions;Lkotlinx/serialization/modules/SerializersModule;)V", "Lsettingdust/kinecraft/serialization/codec/internal/decoder/DecoderState;", "state", "", "pushState", "(Lsettingdust/kinecraft/serialization/codec/internal/decoder/DecoderState;)V", "popState", "()V", "Lkotlin/Pair;", "Lsettingdust/kinecraft/serialization/codec/internal/ElementOptions;", "getElementAndPop", "()Lkotlin/Pair;", "elementOptions", "", "stringsAllowedForElement", "(Lsettingdust/kinecraft/serialization/codec/internal/ElementOptions;)Z", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "", "decodeElementIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "decodeSequentially", "()Z", "decodeCollectionSize", "Lkotlinx/serialization/encoding/CompositeDecoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeDecoder;", "endStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "Lkotlinx/serialization/DeserializationStrategy;", "deserializer", "decodeSerializableValue", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "Lkotlinx/serialization/encoding/Decoder;", "decodeInline", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/Decoder;", "decodeNotNullMark", "", "decodeNull", "()Ljava/lang/Void;", "enumDescriptor", "decodeEnum", "caseInsensitive", "decodeEnumByName", "(Ljava/lang/Object;Lkotlinx/serialization/descriptors/SerialDescriptor;Z)Ljava/lang/Integer;", "allowStringInput", "decodeEnumByIndex", "A", "Lcom/mojang/serialization/Codec;", "codec", "", "typeName", "decodeExternal", "(Lcom/mojang/serialization/Codec;Ljava/lang/String;)Ljava/lang/Object;", "R", "Lkotlin/Function1;", "Lcom/mojang/serialization/DataResult;", "fromInput", "fromString", "decodeValue", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "", "fromNumber", "decodeNumber", "decodeBoolean", "", "decodeByte", "()B", "", "decodeShort", "()S", "decodeInt", "()I", "", "decodeLong", "()J", "", "decodeFloat", "()F", "", "decodeDouble", "()D", "", "decodeChar", "()C", "decodeString", "()Ljava/lang/String;", "collectTrace", "Lcom/mojang/serialization/DynamicOps;", "getOps", "()Lcom/mojang/serialization/DynamicOps;", "Lsettingdust/kinecraft/serialization/codec/options/CodecOptions;", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "Lsettingdust/kinecraft/serialization/codec/ExtendedDynamicOps;", "extendedOps", "Lsettingdust/kinecraft/serialization/codec/ExtendedDynamicOps;", "Lsettingdust/kinecraft/serialization/codec/internal/SerializationConfig;", "serializationConfig", "Lsettingdust/kinecraft/serialization/codec/internal/SerializationConfig;", "Lkotlin/collections/ArrayDeque;", "stateStack", "Lkotlin/collections/ArrayDeque;", "getCurrentState", "()Lsettingdust/kinecraft/serialization/codec/internal/decoder/DecoderState;", "currentState", "kinecraft_fabric121"})
@SourceDebugExtension(value={"SMAP\nDynamicDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicDecoder.kt\nsettingdust/kinecraft/serialization/codec/internal/decoder/DynamicDecoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,412:1\n356#1,13:430\n356#1,13:443\n375#1:456\n356#1,13:457\n375#1:470\n356#1,13:471\n375#1:484\n356#1,13:485\n375#1:498\n356#1,13:499\n375#1:512\n356#1,13:513\n375#1:526\n356#1,13:527\n1583#2,11:413\n1878#2,2:424\n1880#2:427\n1594#2:428\n1617#2,9:540\n1869#2:549\n1870#2:551\n1626#2:552\n1#3:426\n1#3:429\n1#3:550\n*S KotlinDebug\n*F\n+ 1 DynamicDecoder.kt\nsettingdust/kinecraft/serialization/codec/internal/decoder/DynamicDecoder\n*L\n375#1:430,13\n379#1:443,13\n381#1:456\n381#1:457,13\n383#1:470\n383#1:471,13\n385#1:484\n385#1:485,13\n387#1:498\n387#1:499,13\n389#1:512\n389#1:513,13\n391#1:526\n391#1:527,13\n276#1:413,11\n276#1:424,2\n276#1:427\n276#1:428\n408#1:540,9\n408#1:549\n408#1:551\n408#1:552\n276#1:426\n408#1:550\n*E\n"})
public final class DynamicDecoder<T>
extends AbstractDecoder {
    @NotNull
    private final DynamicOps<T> ops;
    @NotNull
    private final CodecOptions options;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final ExtendedDynamicOps<T> extendedOps;
    @NotNull
    private final SerializationConfig<T> serializationConfig;
    @NotNull
    private final ArrayDeque<DecoderState<T>> stateStack;

    public DynamicDecoder(@NotNull DynamicOps<T> ops, @NotNull T input, @NotNull CodecOptions options, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        this.ops = ops;
        this.options = options;
        this.serializersModule = serializersModule;
        this.extendedOps = DataUtilKt.getExtendedWithDefault(this.ops);
        this.serializationConfig = new SerializationConfig<T>(this.ops, this.extendedOps, this.options);
        this.stateStack = new ArrayDeque();
        this.pushState(new RootState<T>(input, this.serializationConfig));
    }

    @NotNull
    public final DynamicOps<T> getOps() {
        return this.ops;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    private final DecoderState<T> getCurrentState() {
        DecoderState decoderState = (DecoderState)this.stateStack.lastOrNull();
        if (decoderState == null) {
            throw new IllegalStateException("Attempting to use decoder state when stack is empty (multiple decode* calls outside a structure or mismatched endStructure)");
        }
        return decoderState;
    }

    private final void pushState(DecoderState<T> state) {
        this.stateStack.addLast(state);
    }

    private final void popState() {
        DynamicDecoder dynamicDecoder = this;
        do {
            dynamicDecoder.getCurrentState().onComplete();
            dynamicDecoder.stateStack.removeLast();
        } while (!dynamicDecoder.stateStack.isEmpty() && !dynamicDecoder.getCurrentState().isStructure());
    }

    private final Pair<T, ElementOptions> getElementAndPop() {
        Pair<T, ElementOptions> elementPair = this.getCurrentState().getElement();
        if (!this.getCurrentState().isStructure()) {
            this.popState();
        }
        return elementPair;
    }

    private final boolean stringsAllowedForElement(ElementOptions elementOptions) {
        return this.options.getAllowStringValues() || elementOptions.isMapKey() && this.extendedOps.getSupportedMapKeys() == ExtendedDynamicOps.ElementSupport.STRINGS;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.getCurrentState().getNextIndex(descriptor);
    }

    public boolean decodeSequentially() {
        return this.getCurrentState().decodeSequentially();
    }

    public int decodeCollectionSize(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Integer n = this.getCurrentState().getCollectionSize();
        return n != null ? n : -1;
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        DecoderState decoderState;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Pair<T, ElementOptions> pair = this.getCurrentState().getElement();
        Object element = pair.component1();
        ElementOptions elementOptions = (ElementOptions)pair.component2();
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            DataResult dataResult = this.ops.getStream(element);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"getStream(...)");
            List list = ((Stream)DataResultExtension.Companion.unwrap(dataResult)).toList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
            decoderState = new ListState(list, this.serializationConfig);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            CollectionState collectionState;
            if (elementOptions.getUseEntryListMap() || this.options.getUseEntryListMaps()) {
                DataResult dataResult = this.ops.getStream(element);
                Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"getStream(...)");
                List list = ((Stream)DataResultExtension.Companion.unwrap(dataResult)).toList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
                collectionState = new EntryListMapState(list, this.serializationConfig);
            } else {
                ValidationUtilKt.validateKeyDescriptor(descriptor.getElementDescriptor(0), this.getSerializersModule(), this.extendedOps.getSupportedMapKeys());
                DataResult dataResult = this.ops.getMap(element);
                Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"getMap(...)");
                Object r = DataResultExtension.Companion.unwrap(dataResult);
                Intrinsics.checkNotNullExpressionValue(r, (String)"unwrap(...)");
                collectionState = new RegularMapState<T>((MapLike)r, this.serializationConfig);
            }
            decoderState = collectionState;
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE)) {
            DataResult dataResult = this.ops.getMap(element);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"getMap(...)");
            Object r = DataResultExtension.Companion.unwrap(dataResult);
            Intrinsics.checkNotNullExpressionValue(r, (String)"unwrap(...)");
            decoderState = new ClassState<T>((MapLike)r, this.serializationConfig);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            DataResult dataResult = this.ops.getMap(element);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"getMap(...)");
            Object r = DataResultExtension.Companion.unwrap(dataResult);
            Intrinsics.checkNotNullExpressionValue(r, (String)"unwrap(...)");
            decoderState = new ObjectState<T>((MapLike)r, this.serializationConfig);
        } else if (serialKind instanceof PolymorphicKind) {
            boolean isFlattened;
            String string;
            if (this.options.getUseClassPropertyIndices()) {
                string = "-1";
            } else {
                string = AnnotationUtilKt.getClassDiscriminator(descriptor);
                if (string == null) {
                    string = this.options.getPolymorphism().getClassDiscriminator();
                }
            }
            String discriminator = string;
            Boolean bl = AnnotationUtilKt.getFlattenPolymorphic(descriptor);
            boolean bl2 = isFlattened = bl != null ? bl.booleanValue() : this.options.getPolymorphism().getFlatten();
            if (isFlattened) {
                ValidationUtilKt.validatePolymorphicFields(this.getSerializersModule(), descriptor, discriminator);
            }
            DataResult dataResult = this.ops.getMap(element);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"getMap(...)");
            Object r = DataResultExtension.Companion.unwrap(dataResult);
            Intrinsics.checkNotNullExpressionValue(r, (String)"unwrap(...)");
            decoderState = new PolymorphicState<T>((MapLike)r, discriminator, isFlattened, elementOptions, this.serializationConfig);
        } else {
            throw new IllegalArgumentException("Serializer of kind " + descriptor.getKind() + " cannot be a structure");
        }
        DecoderState newState = decoderState;
        this.pushState(newState);
        return (CompositeDecoder)this;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!this.getCurrentState().isStructure()) {
            throw new IllegalStateException("endStructure called on a non-structural state " + this.getCurrentState().getClass().getSimpleName());
        }
        this.popState();
    }

    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        if (deserializer.getDescriptor().isNullable() && deserializer.getDescriptor().isInline()) {
            ValidationUtilKt.validateNullableInline(deserializer.getDescriptor(), this.options);
        }
        return (T)super.decodeSerializableValue(deserializer);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public Decoder decodeInline(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.getCurrentState() instanceof NullableState) {
            ValidationUtilKt.validateNullableInline(descriptor, this.options);
        }
        var2_2 = this.getCurrentState().getElement();
        element = var2_2.component1();
        elementOptions = (ElementOptions)var2_2.component2();
        v0 = requiresPrimitives = elementOptions.isMapKey() != false && this.extendedOps.getSupportedMapKeys() != ExtendedDynamicOps.ElementSupport.ANY;
        if (requiresPrimitives) ** GOTO lbl-1000
        v1 = AnnotationUtilKt.getUseInlineWrapper(descriptor);
        if (v1 != null ? v1.booleanValue() : this.options.getUseInlineWrappers()) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        useWrapper = v2;
        this.pushState(new InlineState<Object>(element, useWrapper, descriptor, elementOptions, this.serializationConfig));
        return (Decoder)this;
    }

    public boolean decodeNotNullMark() {
        boolean bl;
        Pair<T, ElementOptions> pair = this.getCurrentState().getElement();
        Object element = pair.component1();
        ElementOptions elementOptions = (ElementOptions)pair.component2();
        if (this.extendedOps.isNotNull(element)) {
            this.pushState(new NullableState<Object>(element, elementOptions, this.serializationConfig));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public Void decodeNull() {
        if (!this.getCurrentState().isStructure()) {
            this.popState();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        int n;
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        Pair<T, ElementOptions> pair = this.getElementAndPop();
        Object input = pair.component1();
        ElementOptions elementOptions = (ElementOptions)pair.component2();
        boolean stringsAllowed = this.stringsAllowedForElement(elementOptions);
        if (this.options.getEnum().getLenientDecoding()) {
            int n2;
            Integer n3 = this.decodeEnumByIndex(input, enumDescriptor, stringsAllowed);
            if (n3 != null) {
                n2 = n3;
                return n2;
            } else {
                Integer n4 = this.decodeEnumByName(input, enumDescriptor, true);
                if (n4 == null) throw new IllegalArgumentException("'Enum " + enumDescriptor.getSerialName() + "' cannot be decoded from " + input + ", must be an index between 0 and " + (enumDescriptor.getElementsCount() - 1) + " or one of " + CollectionsKt.joinToString$default((Iterable)SerialDescriptorKt.getElementNames((SerialDescriptor)enumDescriptor), null, null, null, (int)0, null, DynamicDecoder::decodeEnum$lambda$0, (int)31, null) + " (case-insensitive)");
                n2 = n4;
            }
            return n2;
        }
        CodecOptions.EnumEncoding enumEncoding = this.options.getEnum().getEncoding();
        if (Intrinsics.areEqual((Object)enumEncoding, (Object)CodecOptions.EnumEncoding.Index.INSTANCE)) {
            Integer n5 = this.decodeEnumByIndex(input, enumDescriptor, stringsAllowed);
            if (n5 == null) throw new IllegalArgumentException("'Enum " + enumDescriptor.getSerialName() + "' cannot be decoded from " + input + ", must be an index between 0 and " + (enumDescriptor.getElementsCount() - 1) + ")");
            n = n5;
            return n;
        } else {
            if (!(enumEncoding instanceof CodecOptions.EnumEncoding.SerialName)) throw new NoWhenBranchMatchedException();
            Integer n6 = this.decodeEnumByName(input, enumDescriptor, ((CodecOptions.EnumEncoding.SerialName)this.options.getEnum().getEncoding()).getCaseInsensitive());
            if (n6 == null) throw new IllegalArgumentException("'Enum " + enumDescriptor.getSerialName() + "' cannot be decoded from " + input + ", must be one of " + CollectionsKt.joinToString$default((Iterable)SerialDescriptorKt.getElementNames((SerialDescriptor)enumDescriptor), null, null, null, (int)0, null, DynamicDecoder::decodeEnum$lambda$1, (int)31, null) + " " + (((CodecOptions.EnumEncoding.SerialName)this.options.getEnum().getEncoding()).getCaseInsensitive() ? "(case-insensitive)" : "case-sensitive"));
            n = n6;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final Integer decodeEnumByName(T input, SerialDescriptor enumDescriptor, boolean caseInsensitive) {
        void $this$mapIndexedNotNullTo$iv$iv;
        DataResult dataResult = this.ops.getStringValue(input);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"getStringValue(...)");
        String string = (String)DataResultExtension.Companion.orNull(dataResult);
        if (string == null) {
            return null;
        }
        String strInput = string;
        Iterable $this$mapIndexedNotNull$iv = SerialDescriptorKt.getElementNames((SerialDescriptor)enumDescriptor);
        boolean $i$f$mapIndexedNotNull2 = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            Pair it$iv$iv;
            void name;
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean k = false;
            String string2 = (String)element$iv$iv;
            int index = index$iv$iv;
            boolean i = false;
            if ((StringsKt.equals((String)name, (String)strInput, (boolean)caseInsensitive) ? TuplesKt.to((Object)index, (Object)name) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean j = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List matches = (List)destination$iv$iv;
        if (matches.size() > 1) {
            String string3;
            String $i$f$mapIndexedNotNull2 = string3 = " (case-insensitive mode is on)";
            String string4 = CollectionsKt.joinToString$default((Iterable)matches, null, null, null, (int)0, null, DynamicDecoder::decodeEnumByName$lambda$3, (int)31, null);
            String string5 = strInput;
            boolean l = false;
            boolean bl = caseInsensitive;
            String string6 = bl ? string3 : null;
            if (string6 == null) {
                string6 = "";
            }
            String string7 = "Multiple enum values match input '" + string5 + "': " + string4 + string6;
            throw new IllegalArgumentException(string7);
        }
        Pair pair = (Pair)CollectionsKt.firstOrNull((List)matches);
        return pair != null ? (Integer)pair.getFirst() : null;
    }

    private final Integer decodeEnumByIndex(T input, SerialDescriptor enumDescriptor, boolean allowStringInput) {
        Integer stringIndex;
        Integer n;
        Integer intIndex;
        DataResult dataResult = this.ops.getNumberValue(input);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"getNumberValue(...)");
        Number number = (Number)DataResultExtension.Companion.orNull(dataResult);
        Integer n2 = intIndex = number != null ? Integer.valueOf(number.intValue()) : null;
        if (intIndex != null) {
            Integer n3 = intIndex;
            int it = ((Number)n3).intValue();
            boolean i = false;
            return (0 <= it ? it < enumDescriptor.getElementsCount() : false) ? n3 : null;
        }
        if (!allowStringInput) {
            return null;
        }
        DataResult dataResult2 = this.ops.getStringValue(input);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult2, (String)"getStringValue(...)");
        String string = (String)DataResultExtension.Companion.orNull(dataResult2);
        Integer it = n = (stringIndex = string != null ? StringsKt.toIntOrNull((String)string) : null);
        boolean j = false;
        IntRange intRange = RangesKt.until((int)0, (int)enumDescriptor.getElementsCount());
        return it != null && intRange.contains(it.intValue()) ? n : null;
    }

    public final <A> A decodeExternal(@NotNull Codec<A> codec, @NotNull String typeName) {
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Pair<T, ElementOptions> pair = this.getElementAndPop();
        Object element = pair.component1();
        ElementOptions elementOptions = (ElementOptions)pair.component2();
        boolean stringsAllowed = this.stringsAllowedForElement(elementOptions);
        DataResult directResult = codec.decode(this.ops, element);
        if (directResult.result().isPresent() || !stringsAllowed) {
            Intrinsics.checkNotNull((Object)directResult);
            return (A)((com.mojang.datafixers.util.Pair)DataResultExtension.Companion.unwrap(directResult)).getFirst();
        }
        DataResult dataResult = this.ops.getStringValue(element);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"getStringValue(...)");
        String stringElement = (String)DataResultExtension.Companion.orNull(dataResult);
        if (stringElement != null) {
            com.mojang.datafixers.util.Pair booleanResult;
            com.mojang.datafixers.util.Pair numberResult;
            Double d = StringsKt.toDoubleOrNull((String)stringElement);
            if (d != null) {
                double it = ((Number)d).doubleValue();
                boolean i = false;
                DataResult dataResult2 = codec.decode(this.ops, this.ops.createNumeric((Number)it));
                Intrinsics.checkNotNullExpressionValue((Object)dataResult2, (String)"decode(...)");
                v3 = (com.mojang.datafixers.util.Pair)DataResultExtension.Companion.orNull(dataResult2);
            } else {
                v3 = numberResult = null;
            }
            if (numberResult != null) {
                return (A)numberResult.getFirst();
            }
            Boolean bl = StringsKt.toBooleanStrictOrNull((String)stringElement);
            if (bl != null) {
                boolean it = bl;
                boolean j = false;
                DataResult dataResult3 = codec.decode(this.ops, this.ops.createBoolean(it));
                Intrinsics.checkNotNullExpressionValue((Object)dataResult3, (String)"decode(...)");
                v6 = (com.mojang.datafixers.util.Pair)DataResultExtension.Companion.orNull(dataResult3);
            } else {
                v6 = booleanResult = null;
            }
            if (booleanResult != null) {
                return (A)booleanResult.getFirst();
            }
        }
        Intrinsics.checkNotNull((Object)directResult);
        throw new IllegalArgumentException("Could not decode value of type '" + typeName + "' with the provided codec: " + DataResultExtension.Companion.getErrorMessage(directResult));
    }

    private final <R> R decodeValue(Function1<? super T, ? extends DataResult<R>> fromInput, Function1<? super String, ? extends R> fromString) {
        Object stringDecoded;
        boolean $i$f$decodeValue = false;
        Pair<T, ElementOptions> pair = this.getElementAndPop();
        Object element = pair.component1();
        ElementOptions elementOptions = (ElementOptions)pair.component2();
        boolean stringsAllowed = this.stringsAllowedForElement(elementOptions);
        DataResult decodedValue = (DataResult)fromInput.invoke(element);
        if (decodedValue.result().isPresent() || !stringsAllowed) {
            return DataResultExtension.Companion.unwrap(decodedValue);
        }
        DataResult dataResult = this.ops.getStringValue(element);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"getStringValue(...)");
        String string = (String)DataResultExtension.Companion.orNull(dataResult);
        Object object = stringDecoded = string != null ? fromString.invoke((Object)string) : null;
        if (object == null) {
            throw new IllegalArgumentException("Could not decode element directly or from a string: " + DataResultExtension.Companion.getErrorMessage(decodedValue));
        }
        return (R)object;
    }

    private final <R> R decodeNumber(Function1<? super Number, ? extends R> fromNumber, Function1<? super String, ? extends R> fromString) {
        Object object;
        boolean $i$f$decodeNumber = false;
        DynamicDecoder this_$iv = this;
        boolean $i$f$decodeValue = false;
        Pair<T, ElementOptions> pair = this_$iv.getElementAndPop();
        Object element$iv = pair.component1();
        ElementOptions elementOptions$iv = (ElementOptions)pair.component2();
        boolean stringsAllowed$iv = this_$iv.stringsAllowedForElement(elementOptions$iv);
        Object it = element$iv;
        boolean i = false;
        Function1<? super Number, ? extends R> function1 = fromNumber;
        DataResult dataResult = this.ops.getNumberValue(it).map(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"map(...)");
        DataResult decodedValue$iv = dataResult;
        if (decodedValue$iv.result().isPresent() || !stringsAllowed$iv) {
            object = DataResultExtension.Companion.unwrap(decodedValue$iv);
        } else {
            DataResult dataResult2 = this_$iv.ops.getStringValue(element$iv);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult2, (String)"getStringValue(...)");
            String string = (String)DataResultExtension.Companion.orNull(dataResult2);
            Object stringDecoded$iv = string != null ? fromString.invoke((Object)string) : null;
            object = stringDecoded$iv;
            if (object == null) {
                throw new IllegalArgumentException("Could not decode element directly or from a string: " + DataResultExtension.Companion.getErrorMessage(decodedValue$iv));
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"decodeValue(...)");
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public boolean decodeBoolean() {
        Object object;
        void this_$iv;
        DynamicDecoder dynamicDecoder = this;
        DynamicOps<T> dynamicOps = this.ops;
        boolean $i$f$decodeValue = false;
        Pair<T, ElementOptions> pair = super.getElementAndPop();
        Object element$iv = pair.component1();
        ElementOptions elementOptions$iv = (ElementOptions)pair.component2();
        boolean stringsAllowed$iv = super.stringsAllowedForElement(elementOptions$iv);
        Object p0 = element$iv;
        boolean i = false;
        DataResult decodedValue$iv = dynamicOps.getBooleanValue(p0);
        if (decodedValue$iv.result().isPresent() || !stringsAllowed$iv) {
            object = DataResultExtension.Companion.unwrap(decodedValue$iv);
        } else {
            Boolean stringDecoded$iv;
            Boolean bl;
            DataResult dataResult = this_$iv.ops.getStringValue(element$iv);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"getStringValue(...)");
            String string = (String)DataResultExtension.Companion.orNull(dataResult);
            if (string != null) {
                String p02 = string;
                boolean j = false;
                bl = StringsKt.toBooleanStrictOrNull((String)p02);
            } else {
                bl = null;
            }
            if ((object = (stringDecoded$iv = bl)) == null) {
                throw new IllegalArgumentException("Could not decode element directly or from a string: " + DataResultExtension.Companion.getErrorMessage(decodedValue$iv));
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"decodeValue(...)");
        return (Boolean)object;
    }

    /*
     * WARNING - void declaration
     */
    public byte decodeByte() {
        Object object;
        void this_$iv;
        DynamicDecoder dynamicDecoder = this;
        Function1 fromNumber$iv = decodeByte.1.INSTANCE;
        boolean $i$f$decodeNumber = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$decodeValue = false;
        Pair<T, ElementOptions> pair = super.getElementAndPop();
        Object element$iv$iv = pair.component1();
        ElementOptions elementOptions$iv$iv = (ElementOptions)pair.component2();
        boolean stringsAllowed$iv$iv = super.stringsAllowedForElement(elementOptions$iv$iv);
        Object it$iv = element$iv$iv;
        boolean j = false;
        Function1 function1 = fromNumber$iv;
        DataResult dataResult = this_$iv.ops.getNumberValue(it$iv).map(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"map(...)");
        DataResult decodedValue$iv$iv = dataResult;
        if (decodedValue$iv$iv.result().isPresent() || !stringsAllowed$iv$iv) {
            object = DataResultExtension.Companion.unwrap(decodedValue$iv$iv);
        } else {
            Byte stringDecoded$iv$iv;
            Byte by;
            DataResult dataResult2 = this_$iv$iv.ops.getStringValue(element$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult2, (String)"getStringValue(...)");
            String string = (String)DataResultExtension.Companion.orNull(dataResult2);
            if (string != null) {
                String p0 = string;
                boolean i = false;
                by = StringsKt.toByteOrNull((String)p0);
            } else {
                by = null;
            }
            if ((object = (stringDecoded$iv$iv = by)) == null) {
                throw new IllegalArgumentException("Could not decode element directly or from a string: " + DataResultExtension.Companion.getErrorMessage(decodedValue$iv$iv));
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"decodeValue(...)");
        return ((Number)object).byteValue();
    }

    /*
     * WARNING - void declaration
     */
    public short decodeShort() {
        Object object;
        void this_$iv;
        DynamicDecoder dynamicDecoder = this;
        Function1 fromNumber$iv = decodeShort.1.INSTANCE;
        boolean $i$f$decodeNumber = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$decodeValue = false;
        Pair<T, ElementOptions> pair = super.getElementAndPop();
        Object element$iv$iv = pair.component1();
        ElementOptions elementOptions$iv$iv = (ElementOptions)pair.component2();
        boolean stringsAllowed$iv$iv = super.stringsAllowedForElement(elementOptions$iv$iv);
        Object it$iv = element$iv$iv;
        boolean j = false;
        Function1 function1 = fromNumber$iv;
        DataResult dataResult = this_$iv.ops.getNumberValue(it$iv).map(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"map(...)");
        DataResult decodedValue$iv$iv = dataResult;
        if (decodedValue$iv$iv.result().isPresent() || !stringsAllowed$iv$iv) {
            object = DataResultExtension.Companion.unwrap(decodedValue$iv$iv);
        } else {
            Short stringDecoded$iv$iv;
            Short s;
            DataResult dataResult2 = this_$iv$iv.ops.getStringValue(element$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult2, (String)"getStringValue(...)");
            String string = (String)DataResultExtension.Companion.orNull(dataResult2);
            if (string != null) {
                String p0 = string;
                boolean i = false;
                s = StringsKt.toShortOrNull((String)p0);
            } else {
                s = null;
            }
            if ((object = (stringDecoded$iv$iv = s)) == null) {
                throw new IllegalArgumentException("Could not decode element directly or from a string: " + DataResultExtension.Companion.getErrorMessage(decodedValue$iv$iv));
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"decodeValue(...)");
        return ((Number)object).shortValue();
    }

    /*
     * WARNING - void declaration
     */
    public int decodeInt() {
        Object object;
        void this_$iv;
        DynamicDecoder dynamicDecoder = this;
        Function1 fromNumber$iv = decodeInt.1.INSTANCE;
        boolean $i$f$decodeNumber = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$decodeValue = false;
        Pair<T, ElementOptions> pair = super.getElementAndPop();
        Object element$iv$iv = pair.component1();
        ElementOptions elementOptions$iv$iv = (ElementOptions)pair.component2();
        boolean stringsAllowed$iv$iv = super.stringsAllowedForElement(elementOptions$iv$iv);
        Object it$iv = element$iv$iv;
        boolean j = false;
        Function1 function1 = fromNumber$iv;
        DataResult dataResult = this_$iv.ops.getNumberValue(it$iv).map(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"map(...)");
        DataResult decodedValue$iv$iv = dataResult;
        if (decodedValue$iv$iv.result().isPresent() || !stringsAllowed$iv$iv) {
            object = DataResultExtension.Companion.unwrap(decodedValue$iv$iv);
        } else {
            Integer stringDecoded$iv$iv;
            Integer n;
            DataResult dataResult2 = this_$iv$iv.ops.getStringValue(element$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult2, (String)"getStringValue(...)");
            String string = (String)DataResultExtension.Companion.orNull(dataResult2);
            if (string != null) {
                String p0 = string;
                boolean i = false;
                n = StringsKt.toIntOrNull((String)p0);
            } else {
                n = null;
            }
            if ((object = (stringDecoded$iv$iv = n)) == null) {
                throw new IllegalArgumentException("Could not decode element directly or from a string: " + DataResultExtension.Companion.getErrorMessage(decodedValue$iv$iv));
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"decodeValue(...)");
        return ((Number)object).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public long decodeLong() {
        Object object;
        void this_$iv;
        DynamicDecoder dynamicDecoder = this;
        Function1 fromNumber$iv = decodeLong.1.INSTANCE;
        boolean $i$f$decodeNumber = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$decodeValue = false;
        Pair<T, ElementOptions> pair = super.getElementAndPop();
        Object element$iv$iv = pair.component1();
        ElementOptions elementOptions$iv$iv = (ElementOptions)pair.component2();
        boolean stringsAllowed$iv$iv = super.stringsAllowedForElement(elementOptions$iv$iv);
        Object it$iv = element$iv$iv;
        boolean j = false;
        Function1 function1 = fromNumber$iv;
        DataResult dataResult = this_$iv.ops.getNumberValue(it$iv).map(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"map(...)");
        DataResult decodedValue$iv$iv = dataResult;
        if (decodedValue$iv$iv.result().isPresent() || !stringsAllowed$iv$iv) {
            object = DataResultExtension.Companion.unwrap(decodedValue$iv$iv);
        } else {
            Long stringDecoded$iv$iv;
            Long l;
            DataResult dataResult2 = this_$iv$iv.ops.getStringValue(element$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult2, (String)"getStringValue(...)");
            String string = (String)DataResultExtension.Companion.orNull(dataResult2);
            if (string != null) {
                String p0 = string;
                boolean i = false;
                l = StringsKt.toLongOrNull((String)p0);
            } else {
                l = null;
            }
            if ((object = (stringDecoded$iv$iv = l)) == null) {
                throw new IllegalArgumentException("Could not decode element directly or from a string: " + DataResultExtension.Companion.getErrorMessage(decodedValue$iv$iv));
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"decodeValue(...)");
        return ((Number)object).longValue();
    }

    /*
     * WARNING - void declaration
     */
    public float decodeFloat() {
        Object object;
        void this_$iv;
        DynamicDecoder dynamicDecoder = this;
        Function1 fromNumber$iv = decodeFloat.1.INSTANCE;
        boolean $i$f$decodeNumber = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$decodeValue = false;
        Pair<T, ElementOptions> pair = super.getElementAndPop();
        Object element$iv$iv = pair.component1();
        ElementOptions elementOptions$iv$iv = (ElementOptions)pair.component2();
        boolean stringsAllowed$iv$iv = super.stringsAllowedForElement(elementOptions$iv$iv);
        Object it$iv = element$iv$iv;
        boolean j = false;
        Function1 function1 = fromNumber$iv;
        DataResult dataResult = this_$iv.ops.getNumberValue(it$iv).map(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"map(...)");
        DataResult decodedValue$iv$iv = dataResult;
        if (decodedValue$iv$iv.result().isPresent() || !stringsAllowed$iv$iv) {
            object = DataResultExtension.Companion.unwrap(decodedValue$iv$iv);
        } else {
            Float stringDecoded$iv$iv;
            Float f;
            DataResult dataResult2 = this_$iv$iv.ops.getStringValue(element$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult2, (String)"getStringValue(...)");
            String string = (String)DataResultExtension.Companion.orNull(dataResult2);
            if (string != null) {
                String p0 = string;
                boolean i = false;
                f = StringsKt.toFloatOrNull((String)p0);
            } else {
                f = null;
            }
            if ((object = (stringDecoded$iv$iv = f)) == null) {
                throw new IllegalArgumentException("Could not decode element directly or from a string: " + DataResultExtension.Companion.getErrorMessage(decodedValue$iv$iv));
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"decodeValue(...)");
        return ((Number)object).floatValue();
    }

    /*
     * WARNING - void declaration
     */
    public double decodeDouble() {
        Object object;
        void this_$iv;
        DynamicDecoder dynamicDecoder = this;
        Function1 fromNumber$iv = decodeDouble.1.INSTANCE;
        boolean $i$f$decodeNumber = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$decodeValue = false;
        Pair<T, ElementOptions> pair = super.getElementAndPop();
        Object element$iv$iv = pair.component1();
        ElementOptions elementOptions$iv$iv = (ElementOptions)pair.component2();
        boolean stringsAllowed$iv$iv = super.stringsAllowedForElement(elementOptions$iv$iv);
        Object it$iv = element$iv$iv;
        boolean j = false;
        Function1 function1 = fromNumber$iv;
        DataResult dataResult = this_$iv.ops.getNumberValue(it$iv).map(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"map(...)");
        DataResult decodedValue$iv$iv = dataResult;
        if (decodedValue$iv$iv.result().isPresent() || !stringsAllowed$iv$iv) {
            object = DataResultExtension.Companion.unwrap(decodedValue$iv$iv);
        } else {
            Double stringDecoded$iv$iv;
            Double d;
            DataResult dataResult2 = this_$iv$iv.ops.getStringValue(element$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult2, (String)"getStringValue(...)");
            String string = (String)DataResultExtension.Companion.orNull(dataResult2);
            if (string != null) {
                String p0 = string;
                boolean i = false;
                d = StringsKt.toDoubleOrNull((String)p0);
            } else {
                d = null;
            }
            if ((object = (stringDecoded$iv$iv = d)) == null) {
                throw new IllegalArgumentException("Could not decode element directly or from a string: " + DataResultExtension.Companion.getErrorMessage(decodedValue$iv$iv));
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"decodeValue(...)");
        return ((Number)object).doubleValue();
    }

    public char decodeChar() {
        String str = this.decodeString();
        Character c = StringsKt.singleOrNull((CharSequence)str);
        if (c == null) {
            throw new IllegalArgumentException("Value must be a single character, was '" + str + "'");
        }
        return c.charValue();
    }

    @NotNull
    public String decodeString() {
        DataResult dataResult = this.ops.getStringValue(this.getElementAndPop().getFirst());
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"getStringValue(...)");
        Object r = DataResultExtension.Companion.unwrap(dataResult);
        Intrinsics.checkNotNullExpressionValue(r, (String)"unwrap(...)");
        return (String)r;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String collectTrace() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)this.stateStack;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean k = false;
            DecoderState it = (DecoderState)element$iv$iv;
            boolean i = false;
            if (it.getElementTrace() == null) continue;
            boolean j = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", (CharSequence)"$", null, (int)0, null, null, (int)60, null);
    }

    private static final CharSequence decodeEnum$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }

    private static final CharSequence decodeEnum$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }

    private static final CharSequence decodeEnumByName$lambda$3(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it.getSecond() + "'";
    }
}

