/*
 * Decompiled with CFR 0.152.
 */
package settingdust.kinecraft.serialization.codec.internal.decoder;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapLike;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.SerialDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import settingdust.kinecraft.serialization.codec.ExtendedDynamicOps;
import settingdust.kinecraft.serialization.codec.internal.ElementOptions;
import settingdust.kinecraft.serialization.codec.internal.SerializationConfig;
import settingdust.kinecraft.serialization.codec.internal.decoder.DecoderState;
import settingdust.kinecraft.serialization.codec.internal.util.AnnotationUtilKt;
import settingdust.kinecraft.util.DataResultExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B5\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t0\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0011\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00028\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0018R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0019R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001aR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u00058\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0019\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lsettingdust/kinecraft/serialization/codec/internal/decoder/InlineState;", "", "T", "Lsettingdust/kinecraft/serialization/codec/internal/decoder/DecoderState;", "input", "", "useWrapper", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lsettingdust/kinecraft/serialization/codec/internal/ElementOptions;", "elementOptions", "Lsettingdust/kinecraft/serialization/codec/internal/SerializationConfig;", "serializationConfig", "<init>", "(Ljava/lang/Object;ZLkotlinx/serialization/descriptors/SerialDescriptor;Lsettingdust/kinecraft/serialization/codec/internal/ElementOptions;Lsettingdust/kinecraft/serialization/codec/internal/SerializationConfig;)V", "", "getNextIndex", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)I", "Lkotlin/Pair;", "getElement", "()Lkotlin/Pair;", "", "getElementTrace", "()Ljava/lang/String;", "Ljava/lang/Object;", "Z", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "Lsettingdust/kinecraft/serialization/codec/internal/ElementOptions;", "isStructure", "()Z", "kinecraft_fabric121"})
public final class InlineState<T>
extends DecoderState<T> {
    @NotNull
    private final T input;
    private final boolean useWrapper;
    @NotNull
    private final SerialDescriptor descriptor;
    @NotNull
    private final ElementOptions elementOptions;
    private final boolean isStructure;

    public InlineState(@NotNull T input, boolean useWrapper, @NotNull SerialDescriptor descriptor, @NotNull ElementOptions elementOptions, @NotNull SerializationConfig<T> serializationConfig) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)elementOptions, (String)"elementOptions");
        Intrinsics.checkNotNullParameter(serializationConfig, (String)"serializationConfig");
        super(serializationConfig, null);
        this.input = input;
        this.useWrapper = useWrapper;
        this.descriptor = descriptor;
        this.elementOptions = elementOptions;
    }

    @Override
    public int getNextIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        throw new UnsupportedOperationException("Inline state does not support structure elements");
    }

    @Override
    @NotNull
    public Pair<T, ElementOptions> getElement() {
        Object element;
        if (!this.useWrapper) {
            return TuplesKt.to(this.input, (Object)ElementOptions.copy$default(this.elementOptions, false, AnnotationUtilKt.useEntryListMapForElement(this.descriptor, 0), 1, null));
        }
        Object key = !this.getOptions().getUseClassPropertyIndices() ? this.getOps().createString(this.descriptor.getElementName(0)) : (this.getExtendedOps().getSupportedMapKeys() == ExtendedDynamicOps.ElementSupport.STRINGS ? this.getOps().createString("0") : this.getOps().createInt(0));
        DataResult dataResult = this.getOps().getMap(this.input);
        Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"getMap(...)");
        MapLike map = (MapLike)DataResultExtension.Companion.orNull(dataResult);
        boolean canBeImplicitNull = !this.getOptions().getExplicitNulls() && this.descriptor.getElementDescriptor(0).isNullable();
        if (map == null || map.get(key) == null && !canBeImplicitNull) {
            throw new IllegalArgumentException("Wrapped inline class '" + this.descriptor.getSerialName() + "' must be a map containing a field '" + key + "' with value of type '" + this.descriptor.getElementDescriptor(0).getSerialName() + "', was " + this.input);
        }
        if (map.get(key) != null) {
            Object object = map.get(key);
            v2 = object;
            Intrinsics.checkNotNull((Object)object);
        } else {
            v2 = element = this.getExtendedOps().createNull();
        }
        if (!this.getOptions().getIgnoreUnknownKeys() && map.entries().count() > 1L) {
            throw new IllegalArgumentException();
        }
        ElementOptions wrappedOptions = new ElementOptions(false, AnnotationUtilKt.useEntryListMapForElement(this.descriptor, 0), 1, null);
        return TuplesKt.to(element, (Object)wrappedOptions);
    }

    @Override
    public boolean isStructure() {
        return this.isStructure;
    }

    @Override
    @Nullable
    public String getElementTrace() {
        return this.useWrapper ? "." + (this.getOptions().getUseClassPropertyIndices() ? "0" : this.descriptor.getElementName(0)) : null;
    }
}

