/*
 * Copyright 2023 The Quilt Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package settingdust.kinecraft.serialization.codec.internal

import com.mojang.serialization.DynamicOps
import settingdust.kinecraft.serialization.codec.ExtendedDynamicOps
import settingdust.kinecraft.serialization.codec.options.CodecOptions

internal abstract class SerializationState<T : Any>(encodingConfig: SerializationConfig<T>) {
    protected val ops: DynamicOps<T> = encodingConfig.ops
    protected val extendedOps: ExtendedDynamicOps<T> = encodingConfig.extendedOps
    protected val options: CodecOptions = encodingConfig.options

    abstract fun getElementTrace(): String?
}

internal data class SerializationConfig<T : Any>(
    val ops: DynamicOps<T>,
    val extendedOps: ExtendedDynamicOps<T>,
    val options: CodecOptions
)

internal data class ElementOptions(
    val isMapKey: Boolean = false,
    val useEntryListMap: Boolean = false
)
