/*
 * Decompiled with CFR 0.152.
 */
package settingdust.kinecraft.serialization.codec.internal.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.ContextAwareKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import settingdust.kinecraft.serialization.codec.ExtendedDynamicOps;
import settingdust.kinecraft.serialization.codec.internal.util.AnnotationUtilKt;
import settingdust.kinecraft.serialization.codec.options.CodecOptions;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000J\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u001aI\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\t\"\b\b\u0000\u0010\u0001*\u00020\u00002\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a'\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u001f\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a'\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0019H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u001b\u0010\u001d\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"", "T", "Lcom/mojang/serialization/MapLike;", "map", "Lcom/mojang/serialization/DynamicOps;", "ops", "", "", "validKeys", "", "collectInvalidKeys", "(Lcom/mojang/serialization/MapLike;Lcom/mojang/serialization/DynamicOps;Ljava/util/Set;)Ljava/util/List;", "Lkotlinx/serialization/modules/SerializersModule;", "module", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "classDiscriminator", "", "validatePolymorphicFields", "(Lkotlinx/serialization/modules/SerializersModule;Lkotlinx/serialization/descriptors/SerialDescriptor;Ljava/lang/String;)V", "Lsettingdust/kinecraft/serialization/codec/options/CodecOptions;", "options", "validateNullableInline", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lsettingdust/kinecraft/serialization/codec/options/CodecOptions;)V", "keyDescriptor", "Lsettingdust/kinecraft/serialization/codec/ExtendedDynamicOps$ElementSupport;", "acceptedElements", "validateKeyDescriptor", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/modules/SerializersModule;Lsettingdust/kinecraft/serialization/codec/ExtendedDynamicOps$ElementSupport;)V", "carrierDescriptor", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/modules/SerializersModule;)Lkotlinx/serialization/descriptors/SerialDescriptor;", "kinecraft_forge1201"})
public final class ValidationUtilKt {
    @NotNull
    public static final <T> List<String> collectInvalidKeys(@NotNull MapLike<T> map, @NotNull DynamicOps<T> ops, @NotNull Set<String> validKeys) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        Intrinsics.checkNotNullParameter(validKeys, (String)"validKeys");
        List<String> keys = map.entries().map(arg_0 -> ValidationUtilKt.collectInvalidKeys$lambda$1(arg_0 -> ValidationUtilKt.collectInvalidKeys$lambda$0(ops, arg_0), arg_0)).toList();
        Intrinsics.checkNotNull(keys);
        return CollectionsKt.minus((Iterable)keys, (Iterable)validKeys);
    }

    public static final void validatePolymorphicFields(@NotNull SerializersModule module, @NotNull SerialDescriptor descriptor, @NotNull String classDiscriminator) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)classDiscriminator, (String)"classDiscriminator");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.OPEN.INSTANCE)) {
            iterable = ContextAwareKt.getPolymorphicDescriptors((SerializersModule)module, (SerialDescriptor)descriptor);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.SEALED.INSTANCE)) {
            iterable = SerialDescriptorKt.getElementDescriptors((SerialDescriptor)descriptor.getElementDescriptor(1));
        } else {
            return;
        }
        Iterable childDescriptors = iterable;
        for (SerialDescriptor child : childDescriptors) {
            if (!CollectionsKt.contains((Iterable)SerialDescriptorKt.getElementNames((SerialDescriptor)child), (Object)classDiscriminator)) continue;
            throw new IllegalArgumentException("Field '" + classDiscriminator + "' in type '" + child.getSerialName() + "' conflicts with the selected class discriminator of its base type '" + descriptor.getSerialName() + ". Change discriminator in options or base type's @CodecSerializable, disable flattened polymorphic encoding, rename the field, or annotate it with @SerialName with a non-conflicting name");
        }
    }

    public static final void validateNullableInline(@NotNull SerialDescriptor descriptor, @NotNull CodecOptions options) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Boolean bl = AnnotationUtilKt.getUseInlineWrapper(descriptor);
        if (bl != null ? bl.booleanValue() : options.getUseInlineWrappers()) {
            return;
        }
        if (descriptor.getElementDescriptor(0).isNullable()) {
            throw new IllegalArgumentException("Encoding a nullable inline class with a nullable backing field without a wrapper is ambiguous. Enable wrappers for type " + descriptor.getSerialName() + " using CodecSerializable#useInlineWrapper or globally using CodecOptions#useInlineWrappers");
        }
    }

    public static final void validateKeyDescriptor(@NotNull SerialDescriptor keyDescriptor, @NotNull SerializersModule module, @NotNull ExtendedDynamicOps.ElementSupport acceptedElements) {
        Intrinsics.checkNotNullParameter((Object)keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)acceptedElements), (String)"acceptedElements");
        if (keyDescriptor.isNullable()) {
            throw new IllegalArgumentException("Regular maps do not support nullable keys");
        }
        if (acceptedElements == ExtendedDynamicOps.ElementSupport.ANY) {
            return;
        }
        SerialDescriptor carrierDescriptor = ValidationUtilKt.carrierDescriptor(keyDescriptor, module);
        SerialKind keyKind = carrierDescriptor.getKind();
        if (!(keyKind instanceof PrimitiveKind || Intrinsics.areEqual((Object)keyKind, (Object)SerialKind.ENUM.INSTANCE) || AnnotationUtilKt.isCodec(carrierDescriptor))) {
            throw new IllegalArgumentException("Regular maps do not support keys of kind " + keyKind + ", enable useEntryListMaps or annotate class property with @CodecEntryListMap");
        }
    }

    private static final SerialDescriptor carrierDescriptor(SerialDescriptor $this$carrierDescriptor, SerializersModule module) {
        SerialDescriptor serialDescriptor;
        if (Intrinsics.areEqual((Object)$this$carrierDescriptor.getKind(), (Object)SerialKind.CONTEXTUAL.INSTANCE)) {
            serialDescriptor = ContextAwareKt.getContextualDescriptor((SerializersModule)module, (SerialDescriptor)$this$carrierDescriptor);
            if (serialDescriptor == null || (serialDescriptor = ValidationUtilKt.carrierDescriptor(serialDescriptor, module)) == null) {
                serialDescriptor = $this$carrierDescriptor;
            }
        } else {
            serialDescriptor = $this$carrierDescriptor.isInline() ? ValidationUtilKt.carrierDescriptor($this$carrierDescriptor.getElementDescriptor(0), module) : $this$carrierDescriptor;
        }
        return serialDescriptor;
    }

    private static final String collectInvalidKeys$lambda$0(DynamicOps $ops, Pair it) {
        return (String)$ops.getStringValue(it.getFirst()).result().get();
    }

    private static final String collectInvalidKeys$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

