/*
 * Decompiled with CFR 0.152.
 */
package settingdust.kinecraft.serialization.codec.internal;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import settingdust.kinecraft.serialization.codec.internal.CodecSerializationException;
import settingdust.kinecraft.serialization.codec.internal.decoder.DynamicDecoder;
import settingdust.kinecraft.serialization.codec.internal.encoder.DynamicEncoder;
import settingdust.kinecraft.serialization.codec.options.CodecOptions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ=\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011\"\b\b\u0001\u0010\f*\u00020\u000b2\u0006\u0010\r\u001a\u00028\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e2\u0006\u0010\u0010\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013JA\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00140\u0011\"\b\b\u0001\u0010\f*\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u000e2\u0006\u0010\r\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001aR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001bR\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lsettingdust/kinecraft/serialization/codec/internal/SerializerCodec;", "A", "Lcom/mojang/serialization/Codec;", "Lkotlinx/serialization/KSerializer;", "serializer", "Lsettingdust/kinecraft/serialization/codec/options/CodecOptions;", "options", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "<init>", "(Lkotlinx/serialization/KSerializer;Lsettingdust/kinecraft/serialization/codec/options/CodecOptions;Lkotlinx/serialization/modules/SerializersModule;)V", "", "T", "input", "Lcom/mojang/serialization/DynamicOps;", "ops", "prefix", "Lcom/mojang/serialization/DataResult;", "encode", "(Ljava/lang/Object;Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "Lcom/mojang/datafixers/util/Pair;", "decode", "(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "", "toString", "()Ljava/lang/String;", "Lkotlinx/serialization/KSerializer;", "Lsettingdust/kinecraft/serialization/codec/options/CodecOptions;", "Lkotlinx/serialization/modules/SerializersModule;", "kinecraft_fabric1201"})
public final class SerializerCodec<A>
implements Codec<A> {
    @NotNull
    private final KSerializer<A> serializer;
    @NotNull
    private final CodecOptions options;
    @NotNull
    private final SerializersModule serializersModule;

    public SerializerCodec(@NotNull KSerializer<A> serializer2, @NotNull CodecOptions options, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        this.serializer = serializer2;
        this.options = options;
        this.serializersModule = serializersModule;
    }

    @NotNull
    public <T> DataResult<T> encode(A input, @NotNull DynamicOps<T> ops, @NotNull T prefix) {
        DataResult dataResult;
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        Intrinsics.checkNotNullParameter(prefix, (String)"prefix");
        DynamicEncoder<A> encoder = new DynamicEncoder<A>(ops, prefix, this.options, this.serializersModule);
        try {
            encoder.encodeSerializableValue((SerializationStrategy)this.serializer, input);
            dataResult = DataResult.success(encoder.getResult());
            Intrinsics.checkNotNull((Object)dataResult);
        }
        catch (Exception e) {
            Object object;
            String trace = encoder.collectTrace();
            if (this.options.getPrintErrorStackTraces()) {
                Throwable throwable = new CodecSerializationException("Encoding exception at " + trace, e).fillInStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"fillInStackTrace(...)");
                object = ExceptionsKt.stackTraceToString((Throwable)throwable);
            } else {
                object = "Encoding exception at " + trace + ": " + e.getMessage();
            }
            String errorMessage = object;
            DataResult dataResult2 = DataResult.error(() -> SerializerCodec.encode$lambda$0(errorMessage));
            Intrinsics.checkNotNull((Object)dataResult2);
            dataResult = dataResult2;
        }
        return dataResult;
    }

    @NotNull
    public <T> DataResult<Pair<A, T>> decode(@NotNull DynamicOps<T> ops, @NotNull T input) {
        DataResult dataResult;
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        DynamicDecoder<T> decoder = new DynamicDecoder<T>(ops, input, this.options, this.serializersModule);
        try {
            dataResult = DataResult.success((Object)Pair.of(decoder.decodeSerializableValue((DeserializationStrategy)this.serializer), (Object)ops.empty()));
            Intrinsics.checkNotNull((Object)dataResult);
        }
        catch (Exception e) {
            Object object;
            String trace = decoder.collectTrace();
            if (this.options.getPrintErrorStackTraces()) {
                Throwable throwable = new CodecSerializationException("Decoding exception at " + trace, e).fillInStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"fillInStackTrace(...)");
                object = ExceptionsKt.stackTraceToString((Throwable)throwable);
            } else {
                object = "Encoding exception at " + trace + ": " + e.getMessage();
            }
            String errorMessage = object;
            DataResult dataResult2 = DataResult.error(() -> SerializerCodec.decode$lambda$1(errorMessage));
            Intrinsics.checkNotNull((Object)dataResult2);
            dataResult = dataResult2;
        }
        return dataResult;
    }

    @NotNull
    public String toString() {
        return "SerializerCodec[" + this.serializer.getDescriptor().getSerialName() + "]";
    }

    private static final String encode$lambda$0(String $errorMessage) {
        return $errorMessage;
    }

    private static final String decode$lambda$1(String $errorMessage) {
        return $errorMessage;
    }
}

