/*
 * Decompiled with CFR 0.152.
 */
package settingdust.kinecraft.serialization;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.ClassSerialDescriptorBuilder;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;
import settingdust.kinecraft.serialization.codec.internal.CodecSerializerAdapter;
import settingdust.kinecraft.serialization.codec.internal.decoder.DynamicDecoder;
import settingdust.kinecraft.serialization.codec.internal.encoder.DynamicEncoder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\u0004\b\u0001\u0010\u00032\b\u0012\u0004\u0012\u00028\u00000\u0004BK\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0007\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR#\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR)\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001b\u001a\u0004\b\u001e\u0010\u001dR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001fR\u001a\u0010!\u001a\u00020 8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lsettingdust/kinecraft/serialization/DispatchedCodecSerializer;", "", "Out", "Type", "Lkotlinx/serialization/KSerializer;", "Lcom/mojang/serialization/Codec;", "targetCodec", "Ljava/util/function/Function;", "type", "codec", "", "serialName", "<init>", "(Lcom/mojang/serialization/Codec;Ljava/util/function/Function;Ljava/util/function/Function;Ljava/lang/String;)V", "Lkotlinx/serialization/encoding/Decoder;", "decoder", "deserialize", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/lang/Object;", "Lkotlinx/serialization/encoding/Encoder;", "encoder", "value", "", "serialize", "(Lkotlinx/serialization/encoding/Encoder;Ljava/lang/Object;)V", "Lcom/mojang/serialization/Codec;", "getTargetCodec", "()Lcom/mojang/serialization/Codec;", "Ljava/util/function/Function;", "getType", "()Ljava/util/function/Function;", "getCodec", "Ljava/lang/String;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "kinecraft_fabric121"})
public class DispatchedCodecSerializer<Out, Type>
implements KSerializer<Out> {
    @NotNull
    private final Codec<Type> targetCodec;
    @NotNull
    private final Function<Out, Type> type;
    @NotNull
    private final Function<Type, Codec<Out>> codec;
    @NotNull
    private final String serialName;
    @NotNull
    private final SerialDescriptor descriptor;

    public DispatchedCodecSerializer(@NotNull Codec<Type> targetCodec, @NotNull Function<Out, Type> type, @NotNull Function<Type, Codec<Out>> codec, @NotNull String serialName) {
        Intrinsics.checkNotNullParameter(targetCodec, (String)"targetCodec");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)serialName, (String)"serialName");
        this.targetCodec = targetCodec;
        this.type = type;
        this.codec = codec;
        this.serialName = serialName;
        this.descriptor = SerialDescriptorsKt.buildSerialDescriptor((String)this.serialName, (SerialKind)((SerialKind)PolymorphicKind.OPEN.INSTANCE), (SerialDescriptor[])new SerialDescriptor[0], DispatchedCodecSerializer::descriptor$lambda$0);
    }

    @NotNull
    public final Codec<Type> getTargetCodec() {
        return this.targetCodec;
    }

    @NotNull
    public final Function<Out, Type> getType() {
        return this.type;
    }

    @NotNull
    public final Function<Type, Codec<Out>> getCodec() {
        return this.codec;
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public Out deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        if (!(decoder instanceof DynamicDecoder)) {
            throw new UnsupportedOperationException("Codec serializers can only be used in Dynamic serialization");
        }
        CompositeDecoder compositeDecoder = ((DynamicDecoder)decoder).beginStructure(this.getDescriptor());
        Object currentType = null;
        Codec<Out> elementCodec = null;
        Object out = null;
        block5: while (true) {
            int index = compositeDecoder.decodeElementIndex(this.getDescriptor());
            switch (index) {
                case 0: {
                    currentType = CompositeDecoder.decodeSerializableElement$default((CompositeDecoder)compositeDecoder, (SerialDescriptor)this.getDescriptor(), (int)0, (DeserializationStrategy)((DeserializationStrategy)new CodecSerializerAdapter<Type>(this.targetCodec, this.serialName)), null, (int)8, null);
                    elementCodec = this.codec.apply(currentType);
                    continue block5;
                }
                case 1: {
                    SerialDescriptor serialDescriptor = this.getDescriptor();
                    Codec<Out> codec = elementCodec;
                    Intrinsics.checkNotNull(codec);
                    out = CompositeDecoder.decodeSerializableElement$default((CompositeDecoder)compositeDecoder, (SerialDescriptor)serialDescriptor, (int)1, (DeserializationStrategy)((DeserializationStrategy)new CodecSerializerAdapter(codec, this.serialName)), null, (int)8, null);
                    continue block5;
                }
                case -1: {
                    break block5;
                }
                default: {
                    throw new IllegalStateException(("Unexpected index: " + index).toString());
                }
            }
            break;
        }
        ((DynamicDecoder)decoder).endStructure(this.getDescriptor());
        Object object = out;
        Intrinsics.checkNotNull(object);
        return (Out)object;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull Out value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (!(encoder instanceof DynamicEncoder)) {
            throw new UnsupportedOperationException("Codec serializers can only be used in Dynamic serialization");
        }
        CompositeEncoder compositeEncoder = ((DynamicEncoder)encoder).beginStructure(this.getDescriptor());
        Type currentType = this.type.apply(value);
        compositeEncoder.encodeSerializableElement(this.getDescriptor(), 0, (SerializationStrategy)new CodecSerializerAdapter<Type>(this.targetCodec, this.serialName), currentType);
        Codec<Out> codec = this.codec.apply(currentType);
        Intrinsics.checkNotNullExpressionValue(codec, (String)"apply(...)");
        Codec<Out> elementCodec = codec;
        compositeEncoder.encodeSerializableElement(this.getDescriptor(), 1, (SerializationStrategy)new CodecSerializerAdapter<Out>(elementCodec, this.serialName), value);
        ((DynamicEncoder)encoder).endStructure(this.getDescriptor());
    }

    private static final Unit descriptor$lambda$0(ClassSerialDescriptorBuilder $this$buildSerialDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$buildSerialDescriptor, (String)"$this$buildSerialDescriptor");
        ClassSerialDescriptorBuilder.element$default((ClassSerialDescriptorBuilder)$this$buildSerialDescriptor, (String)"type", (SerialDescriptor)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE).getDescriptor(), null, (boolean)false, (int)12, null);
        ClassSerialDescriptorBuilder.element$default((ClassSerialDescriptorBuilder)$this$buildSerialDescriptor, (String)"value", (SerialDescriptor)SerialDescriptorsKt.buildSerialDescriptor$default((String)("DispatchedCodecSerializer<" + $this$buildSerialDescriptor.getSerialName() + ">"), (SerialKind)((SerialKind)SerialKind.CONTEXTUAL.INSTANCE), (SerialDescriptor[])new SerialDescriptor[0], null, (int)8, null), null, (boolean)false, (int)12, null);
        return Unit.INSTANCE;
    }
}

