/*
 * Decompiled with CFR 0.152.
 */
package settingdust.kinecraft.serialization.codec.internal.encoder;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import settingdust.kinecraft.serialization.codec.ExtendedDynamicOps;
import settingdust.kinecraft.serialization.codec.internal.ElementOptions;
import settingdust.kinecraft.serialization.codec.internal.SerializationConfig;
import settingdust.kinecraft.serialization.codec.internal.encoder.ClassState;
import settingdust.kinecraft.serialization.codec.internal.encoder.EncoderState;
import settingdust.kinecraft.serialization.codec.internal.encoder.EntryListMapState;
import settingdust.kinecraft.serialization.codec.internal.encoder.InlineState;
import settingdust.kinecraft.serialization.codec.internal.encoder.ListState;
import settingdust.kinecraft.serialization.codec.internal.encoder.MapState;
import settingdust.kinecraft.serialization.codec.internal.encoder.NullableState;
import settingdust.kinecraft.serialization.codec.internal.encoder.ObjectState;
import settingdust.kinecraft.serialization.codec.internal.encoder.PolymorphicState;
import settingdust.kinecraft.serialization.codec.internal.encoder.RegularMapState;
import settingdust.kinecraft.serialization.codec.internal.encoder.RootState;
import settingdust.kinecraft.serialization.codec.internal.encoder.SingleValueState;
import settingdust.kinecraft.serialization.codec.internal.encoder.StructuredEncoderState;
import settingdust.kinecraft.serialization.codec.internal.util.AnnotationUtilKt;
import settingdust.kinecraft.serialization.codec.internal.util.DataUtilKt;
import settingdust.kinecraft.serialization.codec.internal.util.ValidationUtilKt;
import settingdust.kinecraft.serialization.codec.options.CodecOptions;
import settingdust.kinecraft.util.DataResultExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B-\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0002J\t\u0010$\u001a\u00020\"H\u0082\u0010J\u0015\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010)\u001a\u00020(H\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0015\u00101\u001a\u00028\u00002\u0006\u00102\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u0002052\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u00106\u001a\u00020\"2\u0006\u0010,\u001a\u00020-H\u0016J)\u00107\u001a\u00020\"\"\u0004\b\u0001\u0010\u00012\f\u00108\u001a\b\u0012\u0004\u0012\u0002H\u0001092\u0006\u00102\u001a\u0002H\u0001H\u0016\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020<2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010=\u001a\u00020\"H\u0016J\b\u0010>\u001a\u00020\"H\u0016J\u0018\u0010?\u001a\u00020\"2\u0006\u0010@\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0013\u0010A\u001a\u00020\"2\u0006\u00102\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J0\u0010B\u001a\u00020\"\"\u0004\b\u0001\u0010C2\u0006\u00102\u001a\u0002HC2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u0002HC\u0012\u0004\u0012\u00028\u00000EH\u0082\b\u00a2\u0006\u0002\u0010FJ\u0010\u0010G\u001a\u00020\"2\u0006\u00102\u001a\u00020+H\u0016J\u0010\u0010H\u001a\u00020\"2\u0006\u00102\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\"2\u0006\u00102\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020\"2\u0006\u00102\u001a\u00020/H\u0016J\u0010\u0010M\u001a\u00020\"2\u0006\u00102\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020\"2\u0006\u00102\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020\"2\u0006\u00102\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020\"2\u0006\u00102\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020\"2\u0006\u00102\u001a\u00020VH\u0016J\u0006\u0010W\u001a\u00020VR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0006\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u00028\u0000X\u0086.\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lsettingdust/kinecraft/serialization/codec/internal/encoder/DynamicEncoder;", "T", "", "Lkotlinx/serialization/encoding/AbstractEncoder;", "ops", "Lcom/mojang/serialization/DynamicOps;", "prefix", "options", "Lsettingdust/kinecraft/serialization/codec/options/CodecOptions;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "<init>", "(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;Lsettingdust/kinecraft/serialization/codec/options/CodecOptions;Lkotlinx/serialization/modules/SerializersModule;)V", "getOps", "()Lcom/mojang/serialization/DynamicOps;", "Ljava/lang/Object;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "result", "getResult", "()Ljava/lang/Object;", "setResult", "(Ljava/lang/Object;)V", "extendedOps", "Lsettingdust/kinecraft/serialization/codec/ExtendedDynamicOps;", "serializationConfig", "Lsettingdust/kinecraft/serialization/codec/internal/SerializationConfig;", "stateStack", "Lkotlin/collections/ArrayDeque;", "Lsettingdust/kinecraft/serialization/codec/internal/encoder/EncoderState;", "currentState", "getCurrentState", "()Lsettingdust/kinecraft/serialization/codec/internal/encoder/EncoderState;", "pushState", "", "state", "popResult", "addElement", "element", "elementOptions", "Lsettingdust/kinecraft/serialization/codec/internal/ElementOptions;", "getOptionsOrThrow", "encodeElement", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "index", "", "shouldEncodeElementDefault", "checkStringify", "value", "(Ljava/lang/Object;)Ljava/lang/Object;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "endStructure", "encodeSerializableValue", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeInline", "Lkotlinx/serialization/encoding/Encoder;", "encodeNotNullMark", "encodeNull", "encodeEnum", "enumDescriptor", "encodeExternal", "encodePrimitive", "V", "encode", "Lkotlin/Function1;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "encodeBoolean", "encodeByte", "", "encodeShort", "", "encodeInt", "encodeLong", "", "encodeFloat", "", "encodeDouble", "", "encodeChar", "", "encodeString", "", "collectTrace", "kinecraft_neoforge121"})
@SourceDebugExtension(value={"SMAP\nDynamicEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicEncoder.kt\nsettingdust/kinecraft/serialization/codec/internal/encoder/DynamicEncoder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,303:1\n268#1,4:304\n267#1,9:308\n268#1,4:317\n267#1,9:321\n268#1,4:330\n267#1,9:334\n268#1,4:343\n267#1,9:347\n268#1,4:356\n267#1,9:360\n268#1,4:369\n267#1,9:373\n268#1,4:382\n267#1,9:386\n268#1,4:395\n267#1,9:399\n268#1,4:408\n267#1,9:412\n268#1,4:421\n267#1,9:425\n268#1,4:434\n267#1,9:438\n1617#2,9:447\n1869#2:456\n1870#2:458\n1626#2:459\n1#3:457\n*S KotlinDebug\n*F\n+ 1 DynamicEncoder.kt\nsettingdust/kinecraft/serialization/codec/internal/encoder/DynamicEncoder\n*L\n246#1:304,4\n246#1:308,9\n255#1:317,4\n255#1:321,9\n277#1:330,4\n277#1:334,9\n279#1:343,4\n279#1:347,9\n281#1:356,4\n281#1:360,9\n283#1:369,4\n283#1:373,9\n285#1:382,4\n285#1:386,9\n287#1:395,4\n287#1:399,9\n289#1:408,4\n289#1:412,9\n291#1:421,4\n291#1:425,9\n293#1:434,4\n293#1:438,9\n299#1:447,9\n299#1:456\n299#1:458\n299#1:459\n299#1:457\n*E\n"})
public final class DynamicEncoder<T>
extends AbstractEncoder {
    @NotNull
    private final DynamicOps<T> ops;
    @NotNull
    private final T prefix;
    @NotNull
    private final CodecOptions options;
    @NotNull
    private final SerializersModule serializersModule;
    public T result;
    @NotNull
    private final ExtendedDynamicOps<T> extendedOps;
    @NotNull
    private final SerializationConfig<T> serializationConfig;
    @NotNull
    private final ArrayDeque<EncoderState<T>> stateStack;
    @Nullable
    private ElementOptions elementOptions;

    public DynamicEncoder(@NotNull DynamicOps<T> ops, @NotNull T prefix, @NotNull CodecOptions options, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        Intrinsics.checkNotNullParameter(prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        this.ops = ops;
        this.prefix = prefix;
        this.options = options;
        this.serializersModule = serializersModule;
        this.extendedOps = DataUtilKt.getExtendedWithDefault(this.ops);
        this.serializationConfig = new SerializationConfig<T>(this.ops, this.extendedOps, this.options);
        this.stateStack = new ArrayDeque();
        this.pushState(new RootState<T>(this.serializationConfig));
    }

    @NotNull
    public final DynamicOps<T> getOps() {
        return this.ops;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @NotNull
    public final T getResult() {
        T t = this.result;
        if (t != null) {
            return t;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"result");
        return (T)Unit.INSTANCE;
    }

    public final void setResult(@NotNull T t) {
        Intrinsics.checkNotNullParameter(t, (String)"<set-?>");
        this.result = t;
    }

    private final EncoderState<T> getCurrentState() {
        EncoderState encoderState = (EncoderState)this.stateStack.lastOrNull();
        if (encoderState == null) {
            throw new IllegalStateException("Attempting to use encoder state when stack is empty (multiple encode* calls outside a structure or mismatched endStructure)");
        }
        return encoderState;
    }

    private final void pushState(EncoderState<T> state) {
        this.stateStack.addLast(state);
    }

    private final void popResult() {
        DynamicEncoder dynamicEncoder = this;
        do {
            Object stateResult = ((EncoderState)dynamicEncoder.stateStack.removeLast()).build();
            if (dynamicEncoder.stateStack.isEmpty()) {
                DataResult dataResult = dynamicEncoder.ops.mergeToPrimitive(dynamicEncoder.prefix, stateResult);
                Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"mergeToPrimitive(...)");
                dynamicEncoder.setResult(DataResultExtension.Companion.unwrap(dataResult));
                return;
            }
            dynamicEncoder.getCurrentState().addElement(dynamicEncoder.checkStringify(stateResult));
        } while (dynamicEncoder.getCurrentState() instanceof SingleValueState);
    }

    private final void addElement(T element) {
        this.getCurrentState().addElement(element);
        if (this.getCurrentState() instanceof SingleValueState) {
            this.popResult();
        }
    }

    private final ElementOptions getOptionsOrThrow() {
        ElementOptions elementOptions;
        EncoderState<T> state = this.getCurrentState();
        if (state instanceof SingleValueState) {
            elementOptions = ((SingleValueState)state).getElementOptions();
        } else if (state instanceof StructuredEncoderState) {
            elementOptions = this.elementOptions;
            if (elementOptions == null) {
                throw new IllegalStateException("Null element options but element was not skipped");
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return elementOptions;
    }

    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        EncoderState<T> state = this.getCurrentState();
        if (!(state instanceof StructuredEncoderState)) {
            throw new IllegalStateException("encodeElement called on a non-structured state " + state.getClass().getSimpleName());
        }
        this.elementOptions = ((StructuredEncoderState)state).beforeStructureElement(descriptor, index);
        return this.elementOptions != null;
    }

    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Boolean bl = AnnotationUtilKt.getEncodeDefaults(descriptor);
        return bl != null ? bl.booleanValue() : this.options.getEncodeDefaults();
    }

    private final T checkStringify(T value) {
        if (!this.getOptionsOrThrow().isMapKey() || this.extendedOps.getSupportedMapKeys() != ExtendedDynamicOps.ElementSupport.STRINGS) {
            return value;
        }
        String string = DataUtilKt.getPrimitiveAsString(this.ops, value);
        if (string != null) {
            String it = string;
            boolean bl = false;
            Object object = this.ops.createString(it);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createString(...)");
            return (T)object;
        }
        throw new IllegalArgumentException("Value " + value + " is not a primitive and cannot be turned into a string");
    }

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        StructuredEncoderState structuredEncoderState;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ElementOptions elementOptions = this.getOptionsOrThrow();
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE)) {
            structuredEncoderState = new ClassState<T>(this.serializationConfig);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE)) {
            structuredEncoderState = new ListState<T>(this.serializationConfig);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            MapState mapState;
            if (elementOptions.getUseEntryListMap() || this.options.getUseEntryListMaps()) {
                mapState = new EntryListMapState<T>(this.serializationConfig);
            } else {
                ValidationUtilKt.validateKeyDescriptor(descriptor.getElementDescriptor(0), this.getSerializersModule(), this.extendedOps.getSupportedMapKeys());
                mapState = new RegularMapState<T>(this.serializationConfig);
            }
            structuredEncoderState = mapState;
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            structuredEncoderState = new ObjectState<T>(this.serializationConfig);
        } else if (serialKind instanceof PolymorphicKind) {
            boolean isFlattened;
            String string;
            if (this.options.getUseClassPropertyIndices()) {
                string = "-1";
            } else {
                string = AnnotationUtilKt.getClassDiscriminator(descriptor);
                if (string == null) {
                    string = this.options.getPolymorphism().getClassDiscriminator();
                }
            }
            String discriminator = string;
            Boolean bl = AnnotationUtilKt.getFlattenPolymorphic(descriptor);
            boolean bl2 = isFlattened = bl != null ? bl.booleanValue() : this.options.getPolymorphism().getFlatten();
            if (isFlattened && !this.options.getUseClassPropertyIndices()) {
                ValidationUtilKt.validatePolymorphicFields(this.getSerializersModule(), descriptor, discriminator);
            }
            structuredEncoderState = new PolymorphicState<T>(discriminator, isFlattened, elementOptions, this.serializationConfig);
        } else {
            throw new IllegalArgumentException("Serializer of kind " + descriptor.getKind() + " cannot be a structure");
        }
        StructuredEncoderState newState = structuredEncoderState;
        this.pushState(newState);
        return (CompositeEncoder)this;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.getCurrentState() instanceof SingleValueState) {
            throw new IllegalStateException("endStructure called on a non-structural state " + this.getCurrentState().getClass().getSimpleName());
        }
        this.popResult();
    }

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        if (serializer2.getDescriptor().isNullable() && serializer2.getDescriptor().isInline()) {
            ValidationUtilKt.validateNullableInline(serializer2.getDescriptor(), this.options);
        }
        super.encodeSerializableValue(serializer2, value);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.getCurrentState() instanceof NullableState) {
            ValidationUtilKt.validateNullableInline(descriptor, this.options);
        }
        v0 = requiresPrimitives = (elementOptions = this.getOptionsOrThrow()).isMapKey() != false && this.extendedOps.getSupportedMapKeys() != ExtendedDynamicOps.ElementSupport.ANY;
        if (requiresPrimitives) ** GOTO lbl-1000
        v1 = AnnotationUtilKt.getUseInlineWrapper(descriptor);
        if (v1 != null ? v1.booleanValue() : this.options.getUseInlineWrappers()) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        useWrapper = v2;
        this.pushState(new InlineState<T>(descriptor, useWrapper, elementOptions, this.serializationConfig));
        return (Encoder)this;
    }

    public void encodeNotNullMark() {
        this.pushState(new NullableState<T>(this.getOptionsOrThrow(), this.serializationConfig));
    }

    public void encodeNull() {
        this.addElement(this.extendedOps.createNull());
    }

    /*
     * WARNING - void declaration
     */
    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        CodecOptions.EnumEncoding enumEncoding = this.options.getEnum().getEncoding();
        if (Intrinsics.areEqual((Object)enumEncoding, (Object)CodecOptions.EnumEncoding.Index.INSTANCE)) {
            Object object;
            void this_$iv;
            DynamicEncoder dynamicEncoder = this;
            Integer n = index;
            DynamicOps<T> dynamicOps = this.ops;
            boolean $i$f$encodePrimitive = false;
            if (super.getOptionsOrThrow().isMapKey()) {
                object = this_$iv.ops.createString(String.valueOf(value$iv));
            } else {
                int p0 = ((Number)value$iv).intValue();
                boolean bl = false;
                object = dynamicOps.createInt(p0);
            }
            Object encoded$iv = object;
            Intrinsics.checkNotNull((Object)encoded$iv);
            super.addElement(encoded$iv);
        } else if (enumEncoding instanceof CodecOptions.EnumEncoding.SerialName) {
            Object object;
            void this_$iv;
            String string;
            if (((CodecOptions.EnumEncoding.SerialName)this.options.getEnum().getEncoding()).getCaseInsensitive()) {
                String string2 = enumDescriptor.getElementName(index).toLowerCase(Locale.ROOT);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            } else {
                string = enumDescriptor.getElementName(index);
            }
            String encodedName = string;
            DynamicEncoder value$iv = this;
            DynamicOps<T> dynamicOps = this.ops;
            boolean $i$f$encodePrimitive = false;
            if (super.getOptionsOrThrow().isMapKey()) {
                object = this_$iv.ops.createString(String.valueOf(encodedName));
            } else {
                String p0 = encodedName;
                boolean bl = false;
                object = dynamicOps.createString(p0);
            }
            Object encoded$iv = object;
            Intrinsics.checkNotNull((Object)encoded$iv);
            super.addElement(encoded$iv);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public final void encodeExternal(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.addElement(this.checkStringify(value));
    }

    private final <V> void encodePrimitive(V value, Function1<? super V, ? extends T> encode) {
        boolean $i$f$encodePrimitive = false;
        Object encoded = this.getOptionsOrThrow().isMapKey() ? this.ops.createString(String.valueOf(value)) : encode.invoke(value);
        Intrinsics.checkNotNull((Object)encoded);
        this.addElement(encoded);
    }

    /*
     * WARNING - void declaration
     */
    public void encodeBoolean(boolean value) {
        Object object;
        void this_$iv;
        DynamicEncoder dynamicEncoder = this;
        Boolean bl = value;
        DynamicOps<T> dynamicOps = this.ops;
        boolean $i$f$encodePrimitive = false;
        if (super.getOptionsOrThrow().isMapKey()) {
            object = this_$iv.ops.createString(String.valueOf(value$iv));
        } else {
            boolean p0 = value$iv.booleanValue();
            boolean bl2 = false;
            object = dynamicOps.createBoolean(p0);
        }
        Object encoded$iv = object;
        Intrinsics.checkNotNull((Object)encoded$iv);
        super.addElement(encoded$iv);
    }

    /*
     * WARNING - void declaration
     */
    public void encodeByte(byte value) {
        Object object;
        void this_$iv;
        DynamicEncoder dynamicEncoder = this;
        Byte by = value;
        DynamicOps<T> dynamicOps = this.ops;
        boolean $i$f$encodePrimitive = false;
        if (super.getOptionsOrThrow().isMapKey()) {
            object = this_$iv.ops.createString(String.valueOf(value$iv));
        } else {
            byte p0 = ((Number)value$iv).byteValue();
            boolean bl = false;
            object = dynamicOps.createByte(p0);
        }
        Object encoded$iv = object;
        Intrinsics.checkNotNull((Object)encoded$iv);
        super.addElement(encoded$iv);
    }

    /*
     * WARNING - void declaration
     */
    public void encodeShort(short value) {
        Object object;
        void this_$iv;
        DynamicEncoder dynamicEncoder = this;
        Short s = value;
        DynamicOps<T> dynamicOps = this.ops;
        boolean $i$f$encodePrimitive = false;
        if (super.getOptionsOrThrow().isMapKey()) {
            object = this_$iv.ops.createString(String.valueOf(value$iv));
        } else {
            short p0 = ((Number)value$iv).shortValue();
            boolean bl = false;
            object = dynamicOps.createShort(p0);
        }
        Object encoded$iv = object;
        Intrinsics.checkNotNull((Object)encoded$iv);
        super.addElement(encoded$iv);
    }

    /*
     * WARNING - void declaration
     */
    public void encodeInt(int value) {
        Object object;
        void this_$iv;
        DynamicEncoder dynamicEncoder = this;
        Integer n = value;
        DynamicOps<T> dynamicOps = this.ops;
        boolean $i$f$encodePrimitive = false;
        if (super.getOptionsOrThrow().isMapKey()) {
            object = this_$iv.ops.createString(String.valueOf(value$iv));
        } else {
            int p0 = ((Number)value$iv).intValue();
            boolean bl = false;
            object = dynamicOps.createInt(p0);
        }
        Object encoded$iv = object;
        Intrinsics.checkNotNull((Object)encoded$iv);
        super.addElement(encoded$iv);
    }

    /*
     * WARNING - void declaration
     */
    public void encodeLong(long value) {
        Object object;
        void this_$iv;
        DynamicEncoder dynamicEncoder = this;
        Long l = value;
        DynamicOps<T> dynamicOps = this.ops;
        boolean $i$f$encodePrimitive = false;
        if (super.getOptionsOrThrow().isMapKey()) {
            object = this_$iv.ops.createString(String.valueOf(value$iv));
        } else {
            long p0 = ((Number)value$iv).longValue();
            boolean bl = false;
            object = dynamicOps.createLong(p0);
        }
        Object encoded$iv = object;
        Intrinsics.checkNotNull((Object)encoded$iv);
        super.addElement(encoded$iv);
    }

    /*
     * WARNING - void declaration
     */
    public void encodeFloat(float value) {
        Object object;
        void this_$iv;
        DynamicEncoder dynamicEncoder = this;
        Float f = Float.valueOf(value);
        DynamicOps<T> dynamicOps = this.ops;
        boolean $i$f$encodePrimitive = false;
        if (super.getOptionsOrThrow().isMapKey()) {
            object = this_$iv.ops.createString(String.valueOf(value$iv));
        } else {
            float p0 = ((Number)value$iv).floatValue();
            boolean bl = false;
            object = dynamicOps.createFloat(p0);
        }
        Object encoded$iv = object;
        Intrinsics.checkNotNull((Object)encoded$iv);
        super.addElement(encoded$iv);
    }

    /*
     * WARNING - void declaration
     */
    public void encodeDouble(double value) {
        Object object;
        void this_$iv;
        DynamicEncoder dynamicEncoder = this;
        Double d = value;
        DynamicOps<T> dynamicOps = this.ops;
        boolean $i$f$encodePrimitive = false;
        if (super.getOptionsOrThrow().isMapKey()) {
            object = this_$iv.ops.createString(String.valueOf(value$iv));
        } else {
            double p0 = ((Number)value$iv).doubleValue();
            boolean bl = false;
            object = dynamicOps.createDouble(p0);
        }
        Object encoded$iv = object;
        Intrinsics.checkNotNull((Object)encoded$iv);
        super.addElement(encoded$iv);
    }

    /*
     * WARNING - void declaration
     */
    public void encodeChar(char value) {
        Object object;
        void this_$iv;
        DynamicEncoder dynamicEncoder = this;
        String string = String.valueOf(value);
        DynamicOps<T> dynamicOps = this.ops;
        boolean $i$f$encodePrimitive = false;
        if (super.getOptionsOrThrow().isMapKey()) {
            object = this_$iv.ops.createString(String.valueOf(value$iv));
        } else {
            void p0 = value$iv;
            boolean bl = false;
            object = dynamicOps.createString((String)p0);
        }
        Object encoded$iv = object;
        Intrinsics.checkNotNull((Object)encoded$iv);
        super.addElement(encoded$iv);
    }

    /*
     * WARNING - void declaration
     */
    public void encodeString(@NotNull String value) {
        Object object;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DynamicEncoder dynamicEncoder = this;
        DynamicOps<T> dynamicOps = this.ops;
        boolean $i$f$encodePrimitive = false;
        if (super.getOptionsOrThrow().isMapKey()) {
            object = this_$iv.ops.createString(String.valueOf(value));
        } else {
            String p0 = value;
            boolean bl = false;
            object = dynamicOps.createString(p0);
        }
        Object encoded$iv = object;
        Intrinsics.checkNotNull((Object)encoded$iv);
        super.addElement(encoded$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String collectTrace() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)this.stateStack;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            EncoderState it = (EncoderState)element$iv$iv;
            boolean bl2 = false;
            if (it.getElementTrace() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", (CharSequence)"$", null, (int)0, null, null, (int)60, null);
    }
}

