/*
 * Decompiled with CFR 0.152.
 */
package settingdust.kinecraft.serialization.nbt.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.descriptors.SerialDescriptor;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import settingdust.kinecraft.serialization.nbt.MinecraftNBT;
import settingdust.kinecraft.serialization.nbt.MinecraftNBTDecoder;
import settingdust.kinecraft.serialization.nbt.internal.TagTreeDecoder;

@ExperimentalSerializationApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\fH\u0014J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lsettingdust/kinecraft/serialization/nbt/internal/CollectionTagDecoder;", "T", "Lnet/minecraft/nbt/Tag;", "Lsettingdust/kinecraft/serialization/nbt/MinecraftNBTDecoder;", "Lsettingdust/kinecraft/serialization/nbt/internal/TagTreeDecoder;", "nbt", "Lsettingdust/kinecraft/serialization/nbt/MinecraftNBT;", "collection", "Lnet/minecraft/nbt/CollectionTag;", "<init>", "(Lsettingdust/kinecraft/serialization/nbt/MinecraftNBT;Lnet/minecraft/nbt/CollectionTag;)V", "size", "", "index", "currentTag", "tag", "", "elementName", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeElementIndex", "decodeCollectionSize", "kinecraft_neoforge121"})
final class CollectionTagDecoder<T extends Tag>
extends TagTreeDecoder
implements MinecraftNBTDecoder {
    @NotNull
    private final CollectionTag<T> collection;
    private final int size;
    private int index;

    public CollectionTagDecoder(@NotNull MinecraftNBT nbt, @NotNull CollectionTag<T> collection) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        super(nbt, (Tag)collection, null);
        this.collection = collection;
        this.size = this.collection.size();
        this.index = -1;
    }

    @Override
    @NotNull
    protected Tag currentTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Object object = this.collection.get(Integer.parseInt(tag));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Tag)object;
    }

    @NotNull
    protected String elementName(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return String.valueOf(index);
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.index < this.size - 1) {
            int n = this.index;
            this.index = n + 1;
            return this.index;
        }
        return -1;
    }

    public int decodeCollectionSize(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.size;
    }
}

