/*
 * Decompiled with CFR 0.152.
 */
package settingdust.kinecraft.serialization.codec.internal;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import settingdust.kinecraft.serialization.codec.internal.CodecSerializationException;
import settingdust.kinecraft.serialization.codec.internal.decoder.DynamicDecoder;
import settingdust.kinecraft.serialization.codec.internal.encoder.DynamicEncoder;
import settingdust.kinecraft.serialization.codec.options.CodecOptions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ;\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\b\b\u0001\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u00112\u0006\u0010\u0012\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0013J?\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\r0\u00150\f\"\b\b\u0001\u0010\r*\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u00112\u0006\u0010\u000f\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lsettingdust/kinecraft/serialization/codec/internal/SerializerCodec;", "A", "Lcom/mojang/serialization/Codec;", "serializer", "Lkotlinx/serialization/KSerializer;", "options", "Lsettingdust/kinecraft/serialization/codec/options/CodecOptions;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "<init>", "(Lkotlinx/serialization/KSerializer;Lsettingdust/kinecraft/serialization/codec/options/CodecOptions;Lkotlinx/serialization/modules/SerializersModule;)V", "encode", "Lcom/mojang/serialization/DataResult;", "T", "", "input", "ops", "Lcom/mojang/serialization/DynamicOps;", "prefix", "(Ljava/lang/Object;Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "decode", "Lcom/mojang/datafixers/util/Pair;", "(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;", "toString", "", "kinecraft_neoforge121"})
public final class SerializerCodec<A>
implements Codec<A> {
    @NotNull
    private final KSerializer<A> serializer;
    @NotNull
    private final CodecOptions options;
    @NotNull
    private final SerializersModule serializersModule;

    public SerializerCodec(@NotNull KSerializer<A> serializer2, @NotNull CodecOptions options, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        this.serializer = serializer2;
        this.options = options;
        this.serializersModule = serializersModule;
    }

    @NotNull
    public <T> DataResult<T> encode(A input, @NotNull DynamicOps<T> ops, @NotNull T prefix) {
        DataResult dataResult;
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        Intrinsics.checkNotNullParameter(prefix, (String)"prefix");
        DynamicEncoder<A> encoder = new DynamicEncoder<A>(ops, prefix, this.options, this.serializersModule);
        try {
            encoder.encodeSerializableValue((SerializationStrategy)this.serializer, input);
            dataResult = DataResult.success(encoder.getResult());
            Intrinsics.checkNotNull((Object)dataResult);
        }
        catch (Exception e) {
            Object object;
            String trace = encoder.collectTrace();
            if (this.options.getPrintErrorStackTraces()) {
                Throwable throwable = new CodecSerializationException("Encoding exception at " + trace, e).fillInStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"fillInStackTrace(...)");
                object = ExceptionsKt.stackTraceToString((Throwable)throwable);
            } else {
                object = "Encoding exception at " + trace + ": " + e.getMessage();
            }
            String errorMessage = object;
            DataResult dataResult2 = DataResult.error(() -> SerializerCodec.encode$lambda$0(errorMessage));
            Intrinsics.checkNotNull((Object)dataResult2);
            dataResult = dataResult2;
        }
        return dataResult;
    }

    @NotNull
    public <T> DataResult<Pair<A, T>> decode(@NotNull DynamicOps<T> ops, @NotNull T input) {
        DataResult dataResult;
        Intrinsics.checkNotNullParameter(ops, (String)"ops");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        DynamicDecoder<T> decoder = new DynamicDecoder<T>(ops, input, this.options, this.serializersModule);
        try {
            dataResult = DataResult.success((Object)Pair.of(decoder.decodeSerializableValue((DeserializationStrategy)this.serializer), (Object)ops.empty()));
            Intrinsics.checkNotNull((Object)dataResult);
        }
        catch (Exception e) {
            Object object;
            String trace = decoder.collectTrace();
            if (this.options.getPrintErrorStackTraces()) {
                Throwable throwable = new CodecSerializationException("Decoding exception at " + trace, e).fillInStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"fillInStackTrace(...)");
                object = ExceptionsKt.stackTraceToString((Throwable)throwable);
            } else {
                object = "Encoding exception at " + trace + ": " + e.getMessage();
            }
            String errorMessage = object;
            DataResult dataResult2 = DataResult.error(() -> SerializerCodec.decode$lambda$1(errorMessage));
            Intrinsics.checkNotNull((Object)dataResult2);
            dataResult = dataResult2;
        }
        return dataResult;
    }

    @NotNull
    public String toString() {
        return "SerializerCodec[" + this.serializer.getDescriptor().getSerialName() + "]";
    }

    private static final String encode$lambda$0(String $errorMessage) {
        return $errorMessage;
    }

    private static final String decode$lambda$1(String $errorMessage) {
        return $errorMessage;
    }
}

