/*
 * Decompiled with CFR 0.152.
 */
package net.bte.mod.blocks;

import com.lx862.jcm.mod.block.ThalesTicketBarrier;
import com.lx862.jcm.mod.block.base.DirectionalBlock;
import com.lx862.jcm.mod.data.BlockProperties;
import java.util.List;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.block.BlockGlassFence;
import org.mtr.mod.block.IBlock;

public class GateTicketBarrierBareBlock
extends DirectionalBlock {
    public static final IntegerProperty FENCE_TYPE = IntegerProperty.of((String)"type", (int)0, (int)10);
    public static final BooleanProperty FLIPPED = BlockProperties.BARRIER_FLIPPED;
    public static final IntegerProperty TEXTURE = IntegerProperty.of((String)"texture", (int)0, (int)10);

    public GateTicketBarrierBareBlock(BlockSettings settings) {
        super(settings);
    }

    public VoxelShape getOutlineShape2(BlockState state, BlockView view, BlockPos pos, ShapeContext context) {
        boolean hasFence = IBlock.getStatePropertySafe((BlockState)state, (IntegerProperty)FENCE_TYPE) != 0;
        boolean flipped = IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)FLIPPED);
        VoxelShape mainBarrierShape = IBlock.getVoxelShapeByDirection((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
        VoxelShape vx1 = hasFence ? (flipped ? IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)13.0, (double)12.0, (double)19.0, (double)16.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING)) : IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)19.0, (double)3.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING))) : VoxelShapes.empty();
        return VoxelShapes.union((VoxelShape)mainBarrierShape, (VoxelShape)vx1);
    }

    public VoxelShape getCollisionShape2(BlockState state, BlockView view, BlockPos pos, ShapeContext context) {
        boolean hasFence = IBlock.getStatePropertySafe((BlockState)state, (IntegerProperty)FENCE_TYPE) != 0;
        boolean flipped = IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)FLIPPED);
        VoxelShape mainBarrierShape = IBlock.getVoxelShapeByDirection((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
        VoxelShape vx1 = hasFence ? (flipped ? IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)13.0, (double)12.0, (double)24.0, (double)16.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING)) : IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)24.0, (double)3.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING))) : VoxelShapes.empty();
        return VoxelShapes.union((VoxelShape)mainBarrierShape, (VoxelShape)vx1);
    }

    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        return this.getFenceState(neighborState, direction, state, World.cast((HolderBase)world), pos);
    }

    private BlockState getFenceState(BlockState stateNear, Direction direction, BlockState state, World world, BlockPos pos) {
        BlockPos nextToPos;
        boolean hasBlockNextToFence;
        if (stateNear.getBlock().data instanceof ThalesTicketBarrier || stateNear.getBlock().data instanceof GateTicketBarrierBareBlock) {
            return state;
        }
        Direction thisDirection = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        if (stateNear.getBlock().data instanceof BlockGlassFence) {
            boolean flipped;
            Direction nearbyFacing = IBlock.getStatePropertySafe((BlockState)stateNear, (DirectionProperty)FACING);
            boolean valid = nearbyFacing == thisDirection || nearbyFacing == thisDirection.getOpposite();
            boolean bl = flipped = nearbyFacing != thisDirection;
            if (direction != thisDirection.rotateYClockwise() && direction != thisDirection.rotateYCounterclockwise()) {
                valid = false;
            }
            if (valid) {
                int fenceType = 0;
                if (stateNear.isOf(Blocks.GLASS_FENCE_CIO.get())) {
                    fenceType = 1;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_CKT.get())) {
                    fenceType = 2;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_HEO.get())) {
                    fenceType = 3;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_MOS.get())) {
                    fenceType = 4;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_PLAIN.get())) {
                    fenceType = 5;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_SHM.get())) {
                    fenceType = 6;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_STAINED.get())) {
                    fenceType = 7;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_STW.get())) {
                    fenceType = 8;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_TSH.get())) {
                    fenceType = 9;
                }
                if (stateNear.isOf(Blocks.GLASS_FENCE_WKS.get())) {
                    fenceType = 10;
                }
                return state.with(new Property((class_2769)GateTicketBarrierBareBlock.FENCE_TYPE.data), (Comparable)Integer.valueOf(fenceType)).with(new Property((class_2769)GateTicketBarrierBareBlock.FLIPPED.data), (Comparable)Boolean.valueOf(flipped));
            }
        }
        boolean bl = hasBlockNextToFence = !world.getBlockState(nextToPos = pos.offset(thisDirection.rotateYCounterclockwise())).isAir();
        if (hasBlockNextToFence) {
            return state;
        }
        return state.with(new Property((class_2769)GateTicketBarrierBareBlock.FENCE_TYPE.data), (Comparable)Integer.valueOf(0));
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        super.addBlockProperties(properties);
        properties.add((HolderBase<?>)FENCE_TYPE);
        properties.add((HolderBase<?>)FLIPPED);
        properties.add((HolderBase<?>)TEXTURE);
    }
}

