/*
 * Decompiled with CFR 0.152.
 */
package org.pixiemays.shulkersNames;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ShulkerNameStorage {
    private final File file;
    private final FileConfiguration config;
    private final JavaPlugin plugin;

    public ShulkerNameStorage(JavaPlugin plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "shulkers.yml");
        if (!this.file.exists()) {
            plugin.saveResource("shulkers.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void saveShulker(Location loc, String name) {
        String key = this.locationToKey(loc);
        this.config.set("shulkers." + key + ".name", (Object)name);
        this.save();
    }

    public void removeShulker(Location loc) {
        this.config.set("shulkers." + this.locationToKey(loc), null);
        this.save();
    }

    public Map<Location, String> getAllShulkers() {
        HashMap<Location, String> result = new HashMap<Location, String>();
        ConfigurationSection section = this.config.getConfigurationSection("shulkers");
        if (section == null) {
            return result;
        }
        for (String key : section.getKeys(false)) {
            String name = section.getString(key + ".name");
            Location loc = this.keyToLocation(key);
            result.put(loc, name);
        }
        return result;
    }

    private String locationToKey(Location loc) {
        return loc.getWorld().getName() + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    private Location keyToLocation(String key) {
        String[] parts = key.split(",");
        World world = Bukkit.getWorld((String)parts[0]);
        int x = Integer.parseInt(parts[1]);
        int y = Integer.parseInt(parts[2]);
        int z = Integer.parseInt(parts[3]);
        return new Location(world, (double)x, (double)y, (double)z);
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

