/*
 * Decompiled with CFR 0.152.
 */
package vadlox.dev.simpleCmdHide;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.User;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public final class SimpleCmdHide
extends JavaPlugin
implements Listener {
    private String mode;
    private String adminPermission;
    private String invalidCommandMessage;
    private String reloadMessage;
    private Map<String, GroupConfig> groupConfigMap;
    private LuckPerms luckPerms;

    public void onEnable() {
        this.saveDefaultConfig();
        this.setupLuckPerms();
        this.loadConfiguration();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    private void setupLuckPerms() {
        RegisteredServiceProvider provider = this.getServer().getServicesManager().getRegistration(LuckPerms.class);
        if (provider != null) {
            this.luckPerms = (LuckPerms)provider.getProvider();
        } else {
            this.getLogger().severe("LuckPerms not found! This plugin requires LuckPerms to work.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void loadConfiguration() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.mode = config.getString("mode", "blacklist").toLowerCase();
        this.adminPermission = config.getString("adminperm", "simplecmdhide.admin");
        this.invalidCommandMessage = this.translateColorCodes(config.getString("invalid-command-message", "&cYou do not have permission to execute this command!"));
        this.reloadMessage = this.translateColorCodes(config.getString("reload-message", "&aSimpleCmdHide configuration reloaded!"));
        this.groupConfigMap = new HashMap<String, GroupConfig>();
        if (config.isConfigurationSection("groups")) {
            for (String string : config.getConfigurationSection("groups").getKeys(false)) {
                String parentGroup = config.getString("groups." + string + ".parent", (String)null);
                List commands = config.getStringList("groups." + string + ".commands");
                ArrayList<String> lowerCaseCommands = new ArrayList<String>();
                for (String command : commands) {
                    lowerCaseCommands.add(command.toLowerCase());
                }
                this.groupConfigMap.put(string, new GroupConfig(parentGroup, lowerCaseCommands));
            }
        }
        this.getLogger().info("Loaded groups and commands:");
        for (Map.Entry entry : this.groupConfigMap.entrySet()) {
            this.getLogger().info("Group: " + (String)entry.getKey() + ", Commands: " + String.valueOf(((GroupConfig)entry.getValue()).commands) + ", Parent: " + ((GroupConfig)entry.getValue()).parentGroup);
        }
    }

    public void onDisable() {
    }

    @EventHandler
    public void onPlayerCommandSend(PlayerCommandSendEvent event) {
        if (!event.getPlayer().hasPermission(this.adminPermission)) {
            Set<String> commandsToProcess = this.getCommandsForPlayerGroup(event.getPlayer());
            if (this.mode.equalsIgnoreCase("blacklist")) {
                event.getCommands().removeAll(commandsToProcess);
            } else if (this.mode.equalsIgnoreCase("whitelist")) {
                event.getCommands().retainAll(commandsToProcess);
            }
            this.getLogger().info("Player: " + event.getPlayer().getName() + ", Available Commands: " + String.valueOf(event.getCommands()));
        }
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String message;
        if (!event.getPlayer().hasPermission(this.adminPermission) && (message = event.getMessage()).startsWith("/")) {
            String[] args = message.substring(1).split(" ");
            String commandLabel = args[0].toLowerCase();
            Set<String> commandsToProcess = this.getCommandsForPlayerGroup(event.getPlayer());
            boolean commandAllowed = this.mode.equalsIgnoreCase("blacklist") ? !commandsToProcess.contains(commandLabel) : (this.mode.equalsIgnoreCase("whitelist") ? commandsToProcess.contains(commandLabel) : true);
            if (!commandAllowed) {
                event.setCancelled(true);
                event.getPlayer().sendMessage(this.invalidCommandMessage);
                this.getLogger().info("Blocked command '" + commandLabel + "' from player '" + event.getPlayer().getName() + "' due to group restrictions.");
            }
        }
    }

    private Set<String> getCommandsForPlayerGroup(Player player) {
        HashSet<String> commandsToProcess = new HashSet<String>();
        User user = this.luckPerms.getUserManager().getUser(player.getUniqueId());
        if (user != null) {
            String primaryGroup = user.getPrimaryGroup().toLowerCase();
            commandsToProcess.addAll(this.getCommandsForGroupAndParents(primaryGroup));
        }
        return commandsToProcess;
    }

    private Set<String> getCommandsForGroupAndParents(String group) {
        HashSet<String> commands = new HashSet<String>();
        GroupConfig groupConfig = this.groupConfigMap.get(group);
        if (groupConfig != null) {
            commands.addAll(groupConfig.commands);
            if (groupConfig.parentGroup != null) {
                commands.addAll(this.getCommandsForGroupAndParents(groupConfig.parentGroup));
            }
        }
        return commands;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("simplecmdhide")) {
            if (!sender.hasPermission("simplecmdhide.reload")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to execute this command.");
                return true;
            }
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                this.loadConfiguration();
                sender.sendMessage(this.reloadMessage);
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /simplecmdhide reload");
            return true;
        }
        return false;
    }

    private String translateColorCodes(String message) {
        Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
        Matcher matcher = hexPattern.matcher(message);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            StringBuilder hexReplacement = new StringBuilder("\u00a7x");
            for (char c : hexColor.toCharArray()) {
                hexReplacement.append('\u00a7').append(c);
            }
            matcher.appendReplacement(buffer, hexReplacement.toString());
        }
        matcher.appendTail(buffer);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }

    private static class GroupConfig {
        String parentGroup;
        List<String> commands;

        public GroupConfig(String parentGroup, List<String> commands) {
            this.parentGroup = parentGroup;
            this.commands = commands;
        }
    }
}

