/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.endpoemext;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Reader;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import xland.mcmod.endpoemext.CreditsElementReader;
import xland.mcmod.endpoemext.EndTextAcceptor;

public class CreditsReader
extends CreditsElementReader {
    private static final Component SEPARATOR_LINE = Component.literal((String)"============").withStyle(ChatFormatting.WHITE);
    private static final String CENTERED_LINE_PREFIX = "           ";

    protected CreditsReader(EndTextAcceptor acceptor) {
        super(acceptor);
    }

    @Override
    protected void read(Reader reader) {
        JsonArray arr = GsonHelper.parseArray((Reader)reader);
        for (JsonElement e : arr) {
            JsonObject eachSection = GsonHelper.convertToJsonObject((JsonElement)e, (String)"section");
            String string = eachSection.get("section").getAsString();
            this.acceptor.addText(SEPARATOR_LINE, true);
            this.acceptor.addText((Component)Component.literal((String)string).withStyle(ChatFormatting.YELLOW), true);
            this.acceptor.addText(SEPARATOR_LINE, true);
            this.acceptor.addEmptyLine();
            this.acceptor.addEmptyLine();
            JsonArray disciplines = eachSection.getAsJsonArray("disciplines");
            if (disciplines != null) {
                for (JsonElement e0 : disciplines) {
                    JsonObject eachDiscipline = e0.getAsJsonObject();
                    String discipline = GsonHelper.getAsString((JsonObject)eachDiscipline, (String)"discipline", (String)"");
                    if (!discipline.isBlank()) {
                        this.acceptor.addText((Component)Component.literal((String)discipline).withStyle(ChatFormatting.YELLOW), true);
                        this.acceptor.addEmptyLine();
                        this.acceptor.addEmptyLine();
                    }
                    JsonArray titles = eachDiscipline.getAsJsonArray("titles");
                    this.readTitles(titles);
                }
                continue;
            }
            JsonArray titles = eachSection.getAsJsonArray("titles");
            this.readTitles(titles);
        }
    }

    private void readTitles(JsonArray titles) {
        for (JsonElement e1 : titles) {
            JsonObject oneTitle = GsonHelper.convertToJsonObject((JsonElement)e1, (String)"title");
            String string2 = oneTitle.get("title").getAsString();
            JsonArray names = GsonHelper.getAsJsonArray((JsonObject)oneTitle, (String)"names");
            this.acceptor.addText((Component)Component.literal((String)string2).withStyle(ChatFormatting.GRAY), false);
            for (JsonElement e2 : names) {
                String name = GsonHelper.convertToString((JsonElement)e2, (String)"name");
                this.acceptor.addText((Component)Component.literal((String)CENTERED_LINE_PREFIX).append(name).withStyle(ChatFormatting.WHITE), false);
            }
            this.acceptor.addEmptyLine();
            this.acceptor.addEmptyLine();
        }
    }
}

