/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.endpoemext;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FormattedCharSequence;
import org.slf4j.Logger;
import xland.mcmod.endpoemext.AlternativeCreditsLocator;
import xland.mcmod.endpoemext.EndTextAcceptor;
import xland.mcmod.endpoemext.IndexedPoemLikeLocator;
import xland.mcmod.endpoemext.Locator;
import xland.mcmod.endpoemext.ModCreditsLocator;
import xland.mcmod.endpoemext.MojangCreditsLocator;
import xland.mcmod.endpoemext.PoemLocator;
import xland.mcmod.endpoemext.VanillaPostCreditsLocator;

public final class Locators {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation PRE_POEM = ResourceLocation.fromNamespaceAndPath((String)"end_poem_extension", (String)"poem_pre.json");
    private static final ResourceLocation POST_POEM = ResourceLocation.fromNamespaceAndPath((String)"end_poem_extension", (String)"poem_post.json");
    private static final ResourceLocation PRE_MOJANG_CREDITS = ResourceLocation.fromNamespaceAndPath((String)"end_poem_extension", (String)"pre_mojang_credits.json");
    private static final ResourceLocation PRE_POSTCREDITS = ResourceLocation.fromNamespaceAndPath((String)"end_poem_extension", (String)"pre_postcredits.json");
    private static final ResourceLocation POST_POSTCREDITS = ResourceLocation.fromNamespaceAndPath((String)"end_poem_extension", (String)"post_postcredits.json");
    private static final String ID_END = "texts/end.txt";
    private static final String ID_CREDITS = "texts/credits.json";
    private static final String ID_POST_CREDITS = "texts/postcredits.txt";

    private Locators() {
    }

    public static boolean tryRedirect(String id, List<FormattedCharSequence> texts, IntCollection centeredLines) {
        EndTextAcceptor acceptor = EndTextAcceptor.createVanilla(texts, centeredLines);
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        switch (id) {
            case "texts/end.txt": {
                Locator locator = new IndexedPoemLikeLocator(PRE_POEM);
                locator.visit(resourceManager, acceptor);
                locator = new PoemLocator();
                locator.visit(resourceManager, acceptor);
                locator = new IndexedPoemLikeLocator(POST_POEM);
                locator.visit(resourceManager, acceptor);
                return true;
            }
            case "texts/credits.json": {
                Locator locator = new AlternativeCreditsLocator(PRE_MOJANG_CREDITS);
                locator.visit(resourceManager, acceptor);
                locator = new MojangCreditsLocator();
                locator.visit(resourceManager, acceptor);
                locator = new ModCreditsLocator();
                locator.visit(resourceManager, acceptor);
                return true;
            }
            case "texts/postcredits.txt": {
                Locator locator = new IndexedPoemLikeLocator(PRE_POSTCREDITS);
                locator.visit(resourceManager, acceptor);
                locator = new VanillaPostCreditsLocator();
                locator.visit(resourceManager, acceptor);
                locator = new IndexedPoemLikeLocator(POST_POSTCREDITS);
                locator.visit(resourceManager, acceptor);
                return true;
            }
        }
        return false;
    }
}

