/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.endpoemext.fabric;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1074;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import xland.mcmod.enchlevellangpatch.api.EnchantmentLevelLangPatch;
import xland.mcmod.endpoemext.VanillaTextLocator;

public final class LangPatchCopyright
implements SimpleSynchronousResourceReloadListener {
    private static final class_2960 IDENTIFIER = class_2960.method_60655((String)"end-poem-extension", (String)"langpatch_copyright");
    public static final Logger LOGGER = LogUtils.getLogger();
    private static volatile Map<String, String> poemCredits = Collections.emptyMap();
    private static final Gson GSON = new Gson();

    public class_2960 getFabricId() {
        return IDENTIFIER;
    }

    public void method_14491(@Nonnull class_3300 resourceManager) {
        Map map = resourceManager.method_14488("texts/end_poem", id -> "end_poem_extension".equals(id.method_12836()) && id.method_12832().endsWith(".metadata"));
        HashMap newMap = Maps.newHashMap();
        for (Map.Entry entry : map.entrySet()) {
            String langKey = StringUtils.removeEnd((String)((class_2960)entry.getKey()).method_12832(), (String)".metadata");
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    newMap.put(langKey, IOUtils.toString((Reader)reader));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load poem translation metadata in language `{}`", (Object)langKey, (Object)e);
            }
        }
        poemCredits = newMap;
    }

    @Nullable
    private static String readUri(String json) {
        try {
            JsonObject obj = (JsonObject)GSON.fromJson(json, JsonObject.class);
            return class_3518.method_15253((JsonObject)obj, (String)"demo", null);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to parse credits json", t);
            return null;
        }
    }

    public static void load() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new LangPatchCopyright());
        EnchantmentLevelLangPatch.registerPatch(Predicate.isEqual("modmenu.descriptionTranslation.end-poem-extension"), (translationStorage, key) -> {
            String originTranslation = (String)translationStorage.get(key);
            Map<String, String> credits = poemCredits;
            Optional<String> o = Optional.ofNullable(credits.get(VanillaTextLocator.getLangCode())).map(LangPatchCopyright::readUri);
            if (o.isEmpty()) {
                return originTranslation;
            }
            String s = class_1074.method_4662((String)"epx.poem.copyright.loaded_with", (Object[])new Object[]{o.get()});
            return originTranslation + s;
        });
    }
}

