/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.endpoemext;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;
import xland.mcmod.endpoemext.CreditsElementReader;
import xland.mcmod.endpoemext.EndTextAcceptor;
import xland.mcmod.endpoemext.Locator;
import xland.mcmod.endpoemext.VanillaTextLocator;

public abstract class IndexedLocator
implements Locator {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public List<Resource> locate(ResourceManager manager) {
        ResourceLocation indexPath = this.getIndexPath();
        List allResources = manager.getResourceStack(indexPath);
        if (allResources.isEmpty()) {
            return Collections.emptyList();
        }
        String defaultSuffix = this.defaultSuffix();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Resource resource : allResources) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonArray arr = GsonHelper.parseArray((Reader)reader);
                    for (JsonElement e : arr) {
                        if (GsonHelper.isStringValue((JsonElement)e)) {
                            resources.add(manager.getResourceOrThrow(ResourceLocation.parse((String)e.getAsString())));
                            continue;
                        }
                        if (!e.isJsonObject()) continue;
                        JsonObject o = e.getAsJsonObject();
                        boolean isI18n = GsonHelper.getAsBoolean((JsonObject)o, (String)"is_i18n", (boolean)false);
                        String path = GsonHelper.getAsString((JsonObject)o, (String)"path");
                        String suffix = GsonHelper.getAsString((JsonObject)o, (String)"default_suffix", (String)defaultSuffix);
                        if (isI18n) {
                            String p0 = IndexedLocator.transformDir(path) + VanillaTextLocator.getLangCode() + "." + suffix;
                            resources.add((Resource)manager.getResource(ResourceLocation.parse((String)p0)).or(() -> manager.getResource(ResourceLocation.parse((String)(IndexedLocator.transformDir(path) + "en_us." + suffix)))).orElseThrow(() -> new FileNotFoundException("i18n resource: " + path)));
                            continue;
                        }
                        resources.add(manager.getResourceOrThrow(ResourceLocation.parse((String)path)));
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to locate partial resources from {}", (Object)indexPath, (Object)e);
            }
        }
        return resources;
    }

    protected abstract ResourceLocation getIndexPath();

    protected String defaultSuffix() {
        return "txt";
    }

    @Override
    public abstract CreditsElementReader openReader(EndTextAcceptor var1);

    private static String transformDir(String path) {
        return path.endsWith("/") ? path : path.concat("/");
    }
}

