package xland.mcmod.endpoemext;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Reader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3518;

public class CreditsReader extends CreditsElementReader {
    private static final class_2561 SEPARATOR_LINE = class_2561.method_43470("============").method_27692(class_124.field_1068);
    private static final String CENTERED_LINE_PREFIX = "\040".repeat(11);   // 11 spaces
    protected CreditsReader(EndTextAcceptor acceptor) {
        super(acceptor);
    }

    @Override
    protected void read(Reader reader) {
        JsonArray arr = class_3518.method_37165(reader);
        for (JsonElement e : arr) {
            JsonObject eachSection = class_3518.method_15295(e, "section");
            String string = eachSection.get("section").getAsString();
            acceptor.addText(SEPARATOR_LINE, true);
            acceptor.addText(class_2561.method_43470(string).method_27692(class_124.field_1054), true);
            acceptor.addText(SEPARATOR_LINE, true);
            acceptor.addEmptyLine();
            acceptor.addEmptyLine();
            JsonArray disciplines = eachSection.getAsJsonArray("disciplines");
            if (disciplines != null) {
                for (JsonElement e0 : disciplines) {
                    JsonObject eachDiscipline = e0.getAsJsonObject();
                    String discipline = class_3518.method_15253(eachDiscipline, "discipline", "");
                    if (!discipline.isBlank()) {
                        // this.addCreditsLine(Component.literal(string2).withStyle(ChatFormatting.YELLOW), true);
                        acceptor.addText(class_2561.method_43470(discipline).method_27692(class_124.field_1054), true);
                        acceptor.addEmptyLine();
                        acceptor.addEmptyLine();
                    }
                    JsonArray titles = eachDiscipline.getAsJsonArray("titles");
                    readTitles(titles);
                }
            } else {
                JsonArray titles = eachSection.getAsJsonArray("titles");
                readTitles(titles);
            }
        }
    }

    private void readTitles(JsonArray titles) {
        for (JsonElement e1 : titles) {
            JsonObject oneTitle = class_3518.method_15295(e1, "title");
            String string2 = oneTitle.get("title").getAsString();
            JsonArray names = class_3518.method_15261(oneTitle, "names");
            acceptor.addText(class_2561.method_43470(string2).method_27692(class_124.field_1080), false);
            for (JsonElement e2 : names) {
                String name = class_3518.method_15287(e2, "name");
                acceptor.addText(
                        class_2561.method_43470(CENTERED_LINE_PREFIX).method_27693(name).method_27692(class_124.field_1068),
                        false);
            }
            acceptor.addEmptyLine();
            acceptor.addEmptyLine();
        }
    }
}
