package xland.mcmod.endpoemext;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import org.slf4j.Logger;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

public abstract class IndexedLocator implements Locator {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public List<class_3298> locate(class_3300 manager) {
        final class_2960 indexPath = getIndexPath();
        //final Optional<Resource> index = manager.getResource(indexPath);
        final List<class_3298> allResources = manager.method_14489(indexPath);
        if (allResources.isEmpty())
            return Collections.emptyList();
        final String defaultSuffix = defaultSuffix();
        List<class_3298> resources = new ArrayList<>();

        for (class_3298 resource : allResources) {
            try (var reader = resource.method_43039()) {
                final JsonArray arr = class_3518.method_37165(reader);
                for (var e : arr) {
                    if (class_3518.method_15286(e)) {
                        resources.add(manager.getResourceOrThrow(class_2960.method_60654(e.getAsString())));
                    } else if (e.isJsonObject()) {
                        var o = e.getAsJsonObject();
                        boolean isI18n = class_3518.method_15258(o, "is_i18n", false);
                        String path = class_3518.method_15265(o, "path");
                        String suffix = class_3518.method_15253(o, "default_suffix", defaultSuffix);
                        if (isI18n) {
                            String p0 = transformDir(path) + VanillaTextLocator.getLangCode() + '.' + suffix;
                            resources.add(manager.method_14486(class_2960.method_60654(p0))
                                    .or(() -> manager.method_14486(class_2960.method_60654(transformDir(path) + "en_us." + suffix)))
                                    .orElseThrow(() -> new FileNotFoundException("i18n resource: " + path)));
                        } else {
                            resources.add(manager.getResourceOrThrow(class_2960.method_60654(path)));
                        }
                    }
                }
            } catch (Exception e) {
                LOGGER.error("Failed to locate partial resources from {}", indexPath, e);
            }
        }

        return resources;
    }

    protected abstract class_2960 getIndexPath();
    protected String defaultSuffix() { return "txt"; }

    @Override
    public abstract CreditsElementReader openReader(EndTextAcceptor acceptor);

    private static String transformDir(String path) {
        return path.endsWith("/") ? path : path.concat("/");
    }
}
