package xland.mcmod.endpoemext;

import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class MojangCreditsLocator implements Locator {
    private static final class_2960 MOJANG_CREDITS = class_2960.method_60656("texts/credits.json");

    @Override
    public List<class_3298> locate(class_3300 manager) {
        try {
            return Collections.singletonList(manager.getResourceOrThrow(MOJANG_CREDITS));
        } catch (FileNotFoundException e) {
            throw new IllegalStateException("Failed to load Mojang credits", e);
        }
    }

    @Override
    public CreditsElementReader openReader(EndTextAcceptor acceptor) {
        return new CreditsReader(acceptor);
    }
}
