package xland.mcmod.endpoemext.fabric;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1074;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import xland.mcmod.enchlevellangpatch.api.EnchantmentLevelLangPatch;
import xland.mcmod.endpoemext.VanillaTextLocator;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;

public final class LangPatchCopyright implements SimpleSynchronousResourceReloadListener {
    private static final class_2960 IDENTIFIER = class_2960.method_60655("end-poem-extension", "langpatch_copyright");
    public static final Logger LOGGER = LogUtils.getLogger();
    private static volatile Map<String, String> poemCredits = Collections.emptyMap();
    private static final Gson GSON = new Gson();

    @Override
    public class_2960 getFabricId() {
        return IDENTIFIER;
    }

    @Override
    public void method_14491(@Nonnull class_3300 resourceManager) {
        Map<class_2960, class_3298> map = resourceManager.method_14488("texts/end_poem",
                id -> "end_poem_extension".equals(id.method_12836()) && id.method_12832().endsWith(".metadata"));
        Map<String, String> newMap = Maps.newHashMap();
        for (Map.Entry<class_2960, class_3298> entry : map.entrySet()) {
            final String langKey = StringUtils.removeEnd(
                    StringUtils.removeStart(entry.getKey().method_12832(), "texts/end_poem/"),
                    ".metadata"
            );
            try (BufferedReader reader = entry.getValue().method_43039()) {
                final JsonObject obj = GSON.fromJson(reader, JsonObject.class);
                final @Nullable String demoUri = class_3518.method_15253(obj, "demo", null);
                newMap.put(langKey, demoUri);
            } catch (IOException | JsonParseException e) {
                LOGGER.warn("Failed to load poem translation metadata in language `{}`", langKey, e);
            }
        }
        poemCredits = newMap;
    }

    public static void load() {
        ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(new LangPatchCopyright());
        EnchantmentLevelLangPatch.registerPatch(
                Predicate.isEqual("modmenu.descriptionTranslation.end-poem-extension"),
                (translationStorage, key) -> {
                    final String originTranslation = translationStorage.get(key);
                    final Map<String, String> credits = poemCredits;
                    @Nullable String o = credits.get(VanillaTextLocator.getLangCode());
                    if (o == null) {
                        return originTranslation;
                    }

                    // Use I18n to allow API re-invoked
                    String s = class_1074.method_4662("epx.poem.copyright.loaded_with", o);
                    return originTranslation + s;
                }
        );
    }
}
