package xland.mcmod.endpoemext.splash;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import org.slf4j.Logger;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;

public record SplashModification(
        Collection<String> add,
        Collection<String> remove
) {
    public SplashModification() {
        this(new LinkedHashSet<>(), new LinkedHashSet<>());
    }

    private void add(String s) {
        remove.remove(s);
        add.add(s);
    }

    private void remove(String s) {
        add.remove(s);
        remove.add(s);
    }

    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 SPLASH_MODIFICATION = class_2960.method_60656("texts/splash_modify.json");

    public static List<String> modify(List<String> list) {
        list = new ArrayList<>(list);
        var resourceManager = class_310.method_1551().method_1478();
        SplashModification modification = new SplashModification();

        for (class_3298 resource : resourceManager.method_14489(SPLASH_MODIFICATION)) {
            try (var reader = resource.method_43039()) {
                final JsonObject obj = class_3518.method_15255(reader);
                readArray(obj, "add", modification::add);
                readArray(obj, "remove", modification::remove);
            } catch (Exception e) {
                LOGGER.error("Failed to read splash config from {}", SPLASH_MODIFICATION, e);
            }
        }

        list.addAll(modification.add());
        list.removeAll(modification.remove());
        return list;
    }

    private static void readArray(JsonObject obj, String key, Consumer<String> c) {
        final JsonArray array = class_3518.method_15292(obj, key, null);
        if (array == null) return;
        for (JsonElement e : array) {
            c.accept(class_3518.method_15287(e, key));
        }
    }
}
