/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.endpoemext;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.slf4j.Logger;
import xland.mcmod.endpoemext.CreditsElementReader;
import xland.mcmod.endpoemext.EndTextAcceptor;
import xland.mcmod.endpoemext.Locator;
import xland.mcmod.endpoemext.VanillaTextLocator;

public abstract class IndexedLocator
implements Locator {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public List<class_3298> locate(class_3300 manager) {
        class_2960 indexPath = this.getIndexPath();
        List allResources = manager.method_14489(indexPath);
        if (allResources.isEmpty()) {
            return Collections.emptyList();
        }
        String defaultSuffix = this.defaultSuffix();
        ArrayList<class_3298> resources = new ArrayList<class_3298>();
        for (class_3298 resource : allResources) {
            try {
                BufferedReader reader = resource.method_43039();
                try {
                    JsonArray arr = class_3518.method_37165((Reader)reader);
                    for (JsonElement e : arr) {
                        if (class_3518.method_15286((JsonElement)e)) {
                            resources.add(manager.getResourceOrThrow(class_2960.method_60654((String)e.getAsString())));
                            continue;
                        }
                        if (!e.isJsonObject()) continue;
                        JsonObject o = e.getAsJsonObject();
                        boolean isI18n = class_3518.method_15258((JsonObject)o, (String)"is_i18n", (boolean)false);
                        String path = class_3518.method_15265((JsonObject)o, (String)"path");
                        String suffix = class_3518.method_15253((JsonObject)o, (String)"default_suffix", (String)defaultSuffix);
                        if (isI18n) {
                            String p0 = IndexedLocator.transformDir(path) + VanillaTextLocator.getLangCode() + "." + suffix;
                            resources.add((class_3298)manager.method_14486(class_2960.method_60654((String)p0)).or(() -> manager.method_14486(class_2960.method_60654((String)(IndexedLocator.transformDir(path) + "en_us." + suffix)))).orElseThrow(() -> new FileNotFoundException("i18n resource: " + path)));
                            continue;
                        }
                        resources.add(manager.getResourceOrThrow(class_2960.method_60654((String)path)));
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to locate partial resources from {}", (Object)indexPath, (Object)e);
            }
        }
        return resources;
    }

    protected abstract class_2960 getIndexPath();

    protected String defaultSuffix() {
        return "txt";
    }

    @Override
    public abstract CreditsElementReader openReader(EndTextAcceptor var1);

    private static String transformDir(String path) {
        return path.endsWith("/") ? path : path.concat("/");
    }
}

