/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.endpoemext.splash;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public record SplashModification(Collection<String> add, Collection<String> remove) {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation SPLASH_MODIFICATION = ResourceLocation.withDefaultNamespace((String)"texts/splash_modify.json");

    public SplashModification() {
        this(new LinkedHashSet<String>(), new LinkedHashSet<String>());
    }

    private void add(String s) {
        this.remove.remove(s);
        this.add.add(s);
    }

    private void remove(String s) {
        this.add.remove(s);
        this.remove.add(s);
    }

    public static List<String> modify(List<String> list) {
        list = new ArrayList<String>(list);
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        SplashModification modification = new SplashModification();
        for (Resource resource : resourceManager.getResourceStack(SPLASH_MODIFICATION)) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonObject obj = GsonHelper.parse((Reader)reader);
                    SplashModification.readArray(obj, "add", modification::add);
                    SplashModification.readArray(obj, "remove", modification::remove);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to read splash config from {}", (Object)SPLASH_MODIFICATION, (Object)e);
            }
        }
        list.addAll(modification.add());
        list.removeAll(modification.remove());
        return list;
    }

    private static void readArray(JsonObject obj, String key, Consumer<String> c) {
        JsonArray array = GsonHelper.getAsJsonArray((JsonObject)obj, (String)key, null);
        if (array == null) {
            return;
        }
        for (JsonElement e : array) {
            c.accept(GsonHelper.convertToString((JsonElement)e, (String)key));
        }
    }
}

