package xland.mcmod.endpoemext;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntCollection;
import org.slf4j.Logger;

import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_5481;

public final class Locators {
    private Locators() {}

    static final Logger LOGGER = LogUtils.getLogger();

    private static final class_2960 PRE_POEM = class_2960.method_60655("end_poem_extension", "poem_pre.json");
    private static final class_2960 POST_POEM = class_2960.method_60655("end_poem_extension", "poem_post.json");
    private static final class_2960 PRE_MOJANG_CREDITS = class_2960.method_60655("end_poem_extension", "pre_mojang_credits.json");
    private static final class_2960 PRE_POSTCREDITS = class_2960.method_60655("end_poem_extension", "pre_postcredits.json");
    private static final class_2960 POST_POSTCREDITS = class_2960.method_60655("end_poem_extension", "post_postcredits.json");

    private static final String ID_END = "texts/end.txt";
    private static final String ID_CREDITS = "texts/credits.json";
    private static final String ID_POST_CREDITS = "texts/postcredits.txt";

    /* @return true if to redirect, false otherwise */
    public static boolean tryRedirect(String id, List<class_5481> texts, IntCollection centeredLines) {
        final EndTextAcceptor acceptor = EndTextAcceptor.createVanilla(texts, centeredLines);
        final class_3300 resourceManager = class_310.method_1551().method_1478();
        Locator locator;

        switch (id) {
            case ID_END -> {
                locator = new IndexedPoemLikeLocator(PRE_POEM);
                locator.visit(resourceManager, acceptor);

                locator = new PoemLocator();
                locator.visit(resourceManager, acceptor);

                locator = new IndexedPoemLikeLocator(POST_POEM);
                locator.visit(resourceManager, acceptor);

                return true;
            }
            case ID_CREDITS -> {
                locator = new AlternativeCreditsLocator(PRE_MOJANG_CREDITS);
                locator.visit(resourceManager, acceptor);

                locator = new MojangCreditsLocator();
                locator.visit(resourceManager, acceptor);

                locator = new ModCreditsLocator();
                locator.visit(resourceManager, acceptor);

                return true;
            }
            case ID_POST_CREDITS -> {
                locator = new IndexedPoemLikeLocator(PRE_POSTCREDITS);
                locator.visit(resourceManager, acceptor);

                locator = new VanillaPostCreditsLocator();
                locator.visit(resourceManager, acceptor);

                locator = new IndexedPoemLikeLocator(POST_POSTCREDITS);
                locator.visit(resourceManager, acceptor);

                return true;
            }
            default -> {
                return false;
            }
        }
    }
}
