package xland.mcmod.endpoemext;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public abstract class VanillaTextLocator implements Locator {
    private final class_2960 vanillaPath;

    protected VanillaTextLocator(class_2960 vanillaPath) {
        this.vanillaPath = vanillaPath;
    }

    public static String getLangCode() {
        return class_310.method_1551().method_1526().method_4669();
    }

    @Override
    public List<class_3298> locate(class_3300 manager) {
        final String langCode = getLangCode();
        return manager.method_14486(getAlternativePath(langCode))
                .or(() -> manager.method_14486(vanillaPath))
                .map(Collections::singletonList)
                .orElseThrow(() -> new IllegalStateException("Mojang should have bundled " + vanillaPath));
    }

    protected abstract class_2960 getAlternativePath(String langCode);

    @Override
    public CreditsElementReader openReader(EndTextAcceptor acceptor) {
        return new PoemLikeTextReader(acceptor);
    }
}
