/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.playerglowing;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class PlayerGlowing
extends JavaPlugin
implements TabExecutor {
    private final Set<String> validColors = new HashSet<String>();

    public void onEnable() {
        this.getCommand("setglow").setExecutor((CommandExecutor)this);
        this.getCommand("setglow").setTabCompleter((TabCompleter)this);
        this.getCommand("removeglow").setExecutor((CommandExecutor)this);
        this.getCommand("removeglow").setTabCompleter((TabCompleter)this);
        for (ChatColor color : ChatColor.values()) {
            if (!color.isColor()) continue;
            this.validColors.add(color.name().toLowerCase());
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd = command.getName().toLowerCase();
        if (cmd.equals("setglow")) {
            String teamName;
            if (args.length != 2) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /setglow <player> <color>");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null || !target.isOnline()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                return true;
            }
            String colorInput = args[1].toLowerCase();
            if (!this.validColors.contains(colorInput)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid color. Valid colors: " + String.join((CharSequence)", ", this.validColors));
                return true;
            }
            ChatColor chatColor = ChatColor.valueOf((String)colorInput.toUpperCase());
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            Team team = scoreboard.getTeam(teamName = "glow_" + chatColor.name().toLowerCase());
            if (team == null) {
                team = scoreboard.registerNewTeam(teamName);
                team.setColor(chatColor);
                team.setPrefix("");
                team.setSuffix("");
                team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
                team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
            }
            for (Team t : scoreboard.getTeams()) {
                if (!t.getName().startsWith("glow_")) continue;
                t.removeEntry(target.getName());
            }
            team.addEntry(target.getName());
            target.setScoreboard(scoreboard);
            target.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, Integer.MAX_VALUE, 1, false, false));
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set " + target.getName() + " glowing with color " + String.valueOf(chatColor) + colorInput.toUpperCase());
            return true;
        }
        if (cmd.equals("removeglow")) {
            if (args.length != 1) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /removeglow <player>");
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null || !target.isOnline()) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                return true;
            }
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            for (Team t : scoreboard.getTeams()) {
                if (!t.getName().startsWith("glow_")) continue;
                t.removeEntry(target.getName());
            }
            target.removePotionEffect(PotionEffectType.GLOWING);
            target.setScoreboard(scoreboard);
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Removed glowing effect from " + target.getName());
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return null;
        }
        if (command.getName().equalsIgnoreCase("setglow") && args.length == 2) {
            return this.validColors.stream().filter(c -> c.startsWith(args[1].toLowerCase())).sorted().toList();
        }
        return Collections.emptyList();
    }
}

