/*
 * Decompiled with CFR 0.152.
 */
package com.quintonc.vs_sails;

import com.quintonc.vs_sails.WindManager;
import com.quintonc.vs_sails.networking.PacketHandler;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;

public class ServerWindManager
extends WindManager {
    private static int tickCount = 0;
    private static double timeInfluence = 0.5;
    private static double randomFactor = 0.25;
    private static Random random;
    private static final List<Integer> DIRECTIONS;

    public static void InitializeWind(ServerLevel world) {
        windStrength = 0.0f;
        windDirection = 0.0f;
        windGustiness = 0.125f;
        random = new Random();
        System.out.println("ServerWindManager Init");
        TickEvent.SERVER_LEVEL_PRE.register(ServerWindManager::onWorldTick);
    }

    private static void onWorldTick(ServerLevel world) {
        if (tickCount == 299) {
            tickCount = 0;
            timeInfluence = random.nextBoolean() ? Math.min(timeInfluence + Math.abs(timeInfluence) * 0.125 + 0.01, 1.0) : Math.max(timeInfluence - Math.abs(timeInfluence) * 0.125 - 0.01, -1.0);
            ServerWindManager.updateWind(world);
        } else {
            ++tickCount;
        }
    }

    private static void updateWind(ServerLevel world) {
        double timeFactor = Math.sin((double)world.m_46468_() / 12000.0 * Math.PI);
        randomFactor = Math.min(Math.max(randomFactor + (random.nextDouble() - 0.5) * (1.0 - randomFactor), 0.0), 0.99);
        if (world.m_7654_().m_129783_().m_46471_() || world.m_7654_().m_129783_().m_46470_()) {
            timeInfluence = 0.0;
        }
        windStrength = (float)Math.copySign(Math.pow(Math.abs(timeFactor), 0.44) * timeInfluence + Math.abs(randomFactor) * (1.0 - timeInfluence), timeFactor);
        windDirection = DIRECTIONS.get(world.m_7654_().m_129783_().m_46941_()).intValue();
        windDirection += 12.0f * windStrength;
        windDirection += 12.0f;
        if (world.m_7654_().m_129783_().m_46470_()) {
            windStrength *= 2.0f;
        } else if (world.m_7654_().m_129783_().m_46471_()) {
            windStrength *= 1.5f;
        }
        windStrength /= 2.0f;
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        world.m_7654_().m_6846_().m_11314_().forEach(serverPlayerEntity -> {
            if (serverPlayerEntity.m_284548_().m_220362_() == BuiltinDimensionTypes.f_223538_) {
                buf.writeFloat(windStrength);
                buf.writeFloat(windDirection);
                NetworkManager.sendToPlayers((Iterable)world.m_7654_().m_6846_().m_11314_(), (ResourceLocation)PacketHandler.WIND_DATA_PACKET, (FriendlyByteBuf)buf);
            }
        });
    }

    static {
        DIRECTIONS = Arrays.asList(225, 90, 270, 0, 180, 315, 45, 135);
    }
}

