/*
 * Decompiled with CFR 0.152.
 */
package com.quintonc.vs_sails;

import com.quintonc.vs_sails.ModSounds;
import com.quintonc.vs_sails.ValkyrienSails;
import com.quintonc.vs_sails.ValkyrienSailsClient;
import com.quintonc.vs_sails.blocks.entity.HelmBlockEntity;
import com.quintonc.vs_sails.blocks.entity.RedstoneHelmBlockEntity;
import com.quintonc.vs_sails.client.particles.WindParticle;
import com.quintonc.vs_sails.registration.SailsBlocks;
import dev.architectury.platform.forge.EventBuses;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="vs_sails")
public class ValkyrienSailsForge {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"vs_sails_forge");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"vs_sails");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"vs_sails");
    public static RegistryObject<BlockEntityType<HelmBlockEntity>> HELM_BLOCK_ENTITY;
    public static RegistryObject<BlockEntityType<RedstoneHelmBlockEntity>> REDSTONE_HELM_BLOCK_ENTITY;
    public static RegistryObject<SimpleParticleType> WIND_PARTICLE;

    public ValkyrienSailsForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        EventBuses.registerModEventBus((String)"vs_sails", (IEventBus)modEventBus);
        ValkyrienSails.init();
        this.registerBlockEntities(modEventBus);
        ValkyrienSailsForge.registerParticles(modEventBus);
        ModSounds.registerSounds();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ValkyrienSails.HELM_BLOCK_ENTITY = (BlockEntityType)HELM_BLOCK_ENTITY.get();
        ValkyrienSails.REDSTONE_HELM_BLOCK_ENTITY = (BlockEntityType)REDSTONE_HELM_BLOCK_ENTITY.get();
        ValkyrienSails.WIND_PARTICLE = (SimpleParticleType)WIND_PARTICLE.get();
    }

    private void registerBlockEntities(IEventBus eventBus) {
        HELM_BLOCK_ENTITY = BLOCK_ENTITIES.register("helm_block_entity", () -> BlockEntityType.Builder.m_155273_(HelmBlockEntity::new, (Block[])new Block[]{(Block)SailsBlocks.HELM_BLOCK.get()}).m_58966_(null));
        REDSTONE_HELM_BLOCK_ENTITY = BLOCK_ENTITIES.register("redstone_helm_block_entity", () -> BlockEntityType.Builder.m_155273_(RedstoneHelmBlockEntity::new, (Block[])new Block[]{(Block)SailsBlocks.REDSTONE_HELM_BLOCK.get()}).m_58966_(null));
        BLOCK_ENTITIES.register(eventBus);
    }

    private static void registerParticles(IEventBus eventBus) {
        PARTICLE_TYPES.register(eventBus);
    }

    static {
        WIND_PARTICLE = PARTICLE_TYPES.register("wind_particle", () -> new SimpleParticleType(true));
    }

    @Mod.EventBusSubscriber(modid="vs_sails", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ValkyrienSailsClient.clientInit();
        }

        @SubscribeEvent
        public static void registerParticleProvider(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)WIND_PARTICLE.get(), WindParticle.Factory::new);
        }
    }
}

