/*
 * Decompiled with CFR 0.152.
 */
package com.quintonc.vs_sails.blocks;

import com.quintonc.vs_sails.blocks.SailBlock;
import com.quintonc.vs_sails.blocks.SailToggleBlock;
import java.util.Map;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RopeBlock
extends SailToggleBlock {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rope_block");
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().collect(Util.m_137448_());

    public RopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level blockView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        BlockPos northPos = blockPos.m_122012_();
        BlockPos eastPos = blockPos.m_122029_();
        BlockPos southPos = blockPos.m_122019_();
        BlockPos westPos = blockPos.m_122024_();
        BlockPos upPos = blockPos.m_7494_();
        BlockPos downPos = blockPos.m_7495_();
        BlockState northState = blockView.m_8055_(northPos);
        BlockState eastState = blockView.m_8055_(eastPos);
        BlockState southState = blockView.m_8055_(southPos);
        BlockState westState = blockView.m_8055_(westPos);
        BlockState upState = blockView.m_8055_(upPos);
        BlockState downState = blockView.m_8055_(downPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Objects.requireNonNull(this.m_49966_()).m_61124_((Property)SET, (Comparable)Boolean.valueOf(true))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnect(northState, northState.m_60783_((BlockGetter)blockView, northPos, Direction.SOUTH))))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnect(eastState, eastState.m_60783_((BlockGetter)blockView, eastPos, Direction.WEST))))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(southState, southState.m_60783_((BlockGetter)blockView, southPos, Direction.NORTH))))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnect(westState, westState.m_60783_((BlockGetter)blockView, westPos, Direction.EAST))))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.canConnect(upState, upState.m_60783_((BlockGetter)blockView, upPos, Direction.DOWN))))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.canConnect(downState, downState.m_60783_((BlockGetter)blockView, downPos, Direction.UP))));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape finalShape = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0));
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0));
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));
        }
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            finalShape = Shapes.m_83110_((VoxelShape)finalShape, (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));
        }
        return finalShape;
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    @Override
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (!(sourceBlock instanceof SailBlock)) {
            super.m_6861_(state, world, pos, sourceBlock, sourcePos, notify);
        }
    }

    @Override
    protected void updateAdjacents(Level world, BlockPos pos, Block sourceBlock) {
        world.m_6289_(pos, sourceBlock);
    }

    public boolean canConnect(BlockState state, boolean neighborIsFullSquare) {
        boolean bl = this.canConnectToRope(state);
        return !RopeBlock.m_152463_((BlockState)state) && neighborIsFullSquare || bl;
    }

    private boolean canConnectToRope(BlockState state) {
        TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("sail_togglers"));
        return state.m_60734_().m_5456_().m_7968_().m_204117_(tag) == this.m_5456_().m_7968_().m_204117_(tag);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.canConnect(neighborState, neighborState.m_60783_((BlockGetter)world, neighborPos, direction.m_122424_()))));
    }
}

