/*
 * Decompiled with CFR 0.152.
 */
package com.quintonc.vs_sails.blocks.entity;

import com.quintonc.vs_sails.blocks.HelmBlock;
import com.quintonc.vs_sails.networking.PacketHandler;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.entity.ShipMountingEntity;

public abstract class BaseHelmBlockEntity
extends BlockEntity {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"base_helm_entity");
    public static int wheelInterval;
    private List<ShipMountingEntity> seats = new ArrayList<ShipMountingEntity>();
    public int wheelAngle;
    public float renderWheelAngle = 360.0f;
    public float renderWheelAngleVel = 0.0f;
    public static int maxAngle;

    public BaseHelmBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public boolean startRiding(Player player, boolean force, BlockPos pos, BlockState state, ServerLevel world) {
        for (int i = this.seats.size() - 1; i > 0; --i) {
            if (!this.seats.get(i).m_20159_()) {
                this.seats.get(i).m_6074_();
                this.seats.remove(i);
                continue;
            }
            if (this.seats.get(i).m_6084_()) continue;
            this.seats.remove(i);
        }
        ShipMountingEntity seat = this.spawnSeat(pos, state, world);
        boolean ride = player.m_7998_((Entity)seat, force);
        if (ride) {
            this.seats.add(seat);
        }
        return ride;
    }

    ShipMountingEntity spawnSeat(BlockPos pos, BlockState state, ServerLevel world) {
        BlockPos newPos = pos.m_121945_(((Direction)state.m_61143_((Property)HelmBlock.FACING)).m_122424_());
        Vector3d mounterPos = state.m_61143_((Property)HelmBlock.FACING) == Direction.NORTH ? new Vector3d((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.125, (double)pos.m_123343_() + 1.3125) : (state.m_61143_((Property)HelmBlock.FACING) == Direction.SOUTH ? new Vector3d((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.125, (double)pos.m_123343_() - 0.3125) : (state.m_61143_((Property)HelmBlock.FACING) == Direction.EAST ? new Vector3d((double)pos.m_123341_() - 0.3125, (double)pos.m_123342_() + 0.125, (double)pos.m_123343_() + 0.5) : new Vector3d((double)pos.m_123341_() + 1.3125, (double)pos.m_123342_() + 0.125, (double)pos.m_123343_() + 0.5)));
        ShipMountingEntity entity = (ShipMountingEntity)ValkyrienSkiesMod.SHIP_MOUNTING_ENTITY_TYPE.m_20615_((Level)world);
        assert (entity != null);
        entity.m_6034_(mounterPos.x(), mounterPos.y(), mounterPos.z());
        entity.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
        entity.m_6478_(MoverType.SELF, new Vec3(0.0, 0.0, 0.0));
        entity.setController(true);
        world.m_47205_((Entity)entity);
        return entity;
    }

    public boolean sit(Player player) {
        boolean force = false;
        return this.startRiding(player, force, this.m_58899_(), this.m_58900_(), (ServerLevel)this.f_58857_);
    }

    public void m_7651_() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            for (int i = this.seats.size() - 1; i > 0; --i) {
                this.seats.get(i).m_6074_();
            }
            this.seats.clear();
        }
        super.m_7651_();
    }

    public boolean rotateWheelRight(BlockState state, ServerLevel world, BlockPos pos) {
        boolean success = false;
        if (this.wheelAngle - wheelInterval >= 0) {
            this.wheelAngle -= wheelInterval;
            this.playWheelSounds((Level)world, pos);
            success = true;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(this.wheelAngle);
        buf.m_130064_(pos);
        NetworkManager.sendToPlayers((Iterable)world.m_7654_().m_6846_().m_11314_(), (ResourceLocation)PacketHandler.WHEEL_ANGLE_PACKET, (FriendlyByteBuf)buf);
        return success;
    }

    public boolean rotateWheelLeft(BlockState state, ServerLevel world, BlockPos pos) {
        boolean success = false;
        if (this.wheelAngle + wheelInterval <= 720) {
            this.wheelAngle += wheelInterval;
            this.playWheelSounds((Level)world, pos);
            success = true;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(this.wheelAngle);
        buf.m_130064_(pos);
        NetworkManager.sendToPlayers((Iterable)world.m_7654_().m_6846_().m_11314_(), (ResourceLocation)PacketHandler.WHEEL_ANGLE_PACKET, (FriendlyByteBuf)buf);
        return success;
    }

    private void playWheelSounds(Level world, BlockPos pos) {
        if ((double)this.wheelAngle / (double)maxAngle == 0.5) {
            world.m_5594_(null, pos.m_7495_(), SoundEvents.f_244067_, SoundSource.BLOCKS, 1.5f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
            world.m_5594_(null, pos.m_7495_(), SoundEvents.f_11672_, SoundSource.BLOCKS, 0.1f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
        } else if (this.wheelAngle == maxAngle || this.wheelAngle == 0) {
            world.m_5594_(null, pos.m_7495_(), SoundEvents.f_244067_, SoundSource.BLOCKS, 1.5f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128405_("wheel_angle", this.wheelAngle);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.wheelAngle = pTag.m_128451_("wheel_angle");
    }

    public abstract ItemStack getRenderStack();

    public int getWheelAngle() {
        return this.wheelAngle;
    }

    public void m_6596_() {
        assert (this.f_58857_ != null);
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        super.m_6596_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

