/*
 * Decompiled with CFR 0.152.
 */
package com.quintonc.vs_sails.mixin;

import com.quintonc.vs_sails.client.ClientWindManager;
import com.quintonc.vs_sails.client.ParticlesToBlow;
import com.quintonc.vs_sails.config.ConfigUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={Particle.class})
public class ParticleMixin {
    @Shadow
    protected double f_107212_;
    @Shadow
    protected double f_107213_;
    @Shadow
    protected double f_107214_;
    @Final
    @Shadow
    protected ClientLevel f_107208_;
    @Unique
    private int lightLevel = 15;

    @ModifyVariable(method={"move(DDD)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private double modifyDx(double dx) {
        if (!Boolean.parseBoolean(ConfigUtils.config.getOrDefault("blow-vanilla-particles", "false"))) {
            return dx;
        }
        String simpleName = this.getClass().getSimpleName();
        if (this.f_107208_.m_45517_(LightLayer.SKY, new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_)) == 0 || this.f_107213_ < 40.0) {
            return dx;
        }
        Vec3 oldParticlePos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 windEffect = this.calculateWindEffect(simpleName, oldParticlePos);
        Vec3 particlePos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 windDirection = new Vec3(Math.cos(Math.toRadians(ClientWindManager.getWindDirection((Level)this.f_107208_, particlePos))), 0.0, Math.sin(Math.toRadians(ClientWindManager.getWindDirection((Level)this.f_107208_, particlePos))));
        double windInfluenceFactor = this.getWindInfluenceFactor(particlePos, windDirection);
        return dx + windEffect.f_82479_ * windInfluenceFactor;
    }

    @ModifyVariable(method={"move(DDD)V"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    private double modifyDy(double dy) {
        return dy;
    }

    @ModifyVariable(method={"move(DDD)V"}, at=@At(value="HEAD"), ordinal=2, argsOnly=true)
    private double modifyDz(double dz) {
        if (!Boolean.parseBoolean(ConfigUtils.config.getOrDefault("blow-vanilla-particles", "false"))) {
            return dz;
        }
        String simpleName = this.getClass().getSimpleName();
        if (this.f_107208_.m_45517_(LightLayer.SKY, new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_)) == 0 || this.f_107213_ < 40.0) {
            return dz;
        }
        Vec3 oldParticlePos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 windEffect = this.calculateWindEffect(simpleName, oldParticlePos);
        Vec3 particlePos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 windDirection = new Vec3(Math.cos(Math.toRadians(ClientWindManager.getWindDirection((Level)this.f_107208_, particlePos))), 0.0, Math.sin(Math.toRadians(ClientWindManager.getWindDirection((Level)this.f_107208_, particlePos))));
        double windInfluenceFactor = this.getWindInfluenceFactor(particlePos, windDirection);
        return dz + windEffect.f_82481_ * windInfluenceFactor;
    }

    @Unique
    private double getWindInfluenceFactor(Vec3 particlePosition, Vec3 windDirection) {
        int range = 5;
        Vec3 invertedWindDirection = windDirection.m_82490_(-1.0);
        for (int i = 1; i <= range; ++i) {
            Vec3 checkPosition = particlePosition.m_82549_(invertedWindDirection.m_82490_((double)i));
            BlockPos pos = new BlockPos((int)checkPosition.m_7096_(), (int)checkPosition.m_7098_(), (int)checkPosition.m_7094_());
            BlockState state = this.f_107208_.m_8055_(pos);
            if (!state.m_60795_() && !this.isNonSolidBlock(state)) continue;
            return 1.0;
        }
        return 0.0;
    }

    @Unique
    private boolean isNonSolidBlock(BlockState state) {
        return state.m_60713_(Blocks.f_50058_) || state.m_60713_(Blocks.f_50050_) || state.m_60713_(Blocks.f_50183_) || state.m_60819_().m_76152_() == Fluids.f_76193_ || state.m_60819_().m_76152_() == Fluids.f_76195_;
    }

    @Unique
    private Vec3 calculateWindEffect(String simpleName, Vec3 particlePos) {
        double windEffectiveness = 0.2;
        if (ParticlesToBlow.fullStrength.contains(simpleName)) {
            windEffectiveness *= 3.0;
        }
        this.lightLevel = this.f_107208_.m_45517_(LightLayer.SKY, new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_));
        BlockPos pos = new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_);
        double angleRadians = Math.toRadians(ClientWindManager.getWindDirection((Level)this.f_107208_, particlePos));
        double windX = Math.cos(angleRadians) * (double)ClientWindManager.getWindStrength((Level)this.f_107208_, pos) * (windEffectiveness *= (double)((float)this.lightLevel / 15.0f));
        double windZ = Math.sin(angleRadians) * (double)ClientWindManager.getWindStrength((Level)this.f_107208_, pos) * windEffectiveness;
        Vec3 initialWindEffect = new Vec3(windX, 0.0, windZ);
        return this.calculateRealisticWindFlow(initialWindEffect, pos);
    }

    @Unique
    private boolean checkForWallInteraction(BlockPos particlePos) {
        for (Direction dir : Direction.values()) {
            BlockState state = this.f_107208_.m_8055_(particlePos.m_121945_(dir));
            if (!state.m_60796_((BlockGetter)this.f_107208_, particlePos.m_121945_(dir))) continue;
            return true;
        }
        return false;
    }

    @Unique
    private Vec3 deflectWind(double windX, double windZ, BlockPos pos) {
        Direction windDirection = this.getWindDirection(windX, windZ);
        Direction wallDirection = this.getWallFacingDirection(pos, windDirection);
        double incidenceAngle = this.calculateIncidenceAngle(windDirection, wallDirection);
        double deflectionFactor = this.calculateDeflectionFactor(incidenceAngle, windX, windZ);
        double deflectedWindX = windX * deflectionFactor;
        double deflectedWindZ = windZ * deflectionFactor;
        return new Vec3(deflectedWindX += this.randomizeDeflection(incidenceAngle), 0.0, deflectedWindZ += this.randomizeDeflection(incidenceAngle));
    }

    @Unique
    private double randomizeDeflection(double incidenceAngle) {
        return Math.random() * Math.cos(Math.toRadians(incidenceAngle)) * 0.05;
    }

    @Unique
    private Direction getWindDirection(double windX, double windZ) {
        double angle = Math.toDegrees(Math.atan2(windZ, windX));
        if (angle < 0.0) {
            angle += 360.0;
        }
        if (angle <= 45.0 || angle > 315.0) {
            return Direction.EAST;
        }
        if (angle > 45.0 && angle <= 135.0) {
            return Direction.SOUTH;
        }
        if (angle > 135.0 && angle <= 225.0) {
            return Direction.WEST;
        }
        if (angle > 225.0) {
            return Direction.NORTH;
        }
        return Direction.EAST;
    }

    @Unique
    private Direction getWallFacingDirection(BlockPos pos, Direction windDirection) {
        for (Direction dir : Direction.values()) {
            BlockState state = this.f_107208_.m_8055_(pos.m_121945_(dir));
            if (!state.m_60796_((BlockGetter)this.f_107208_, pos.m_121945_(dir)) || !dir.m_122434_().m_122479_()) continue;
            return dir;
        }
        return windDirection;
    }

    @Unique
    private double calculateIncidenceAngle(Direction windDirection, Direction wallDirection) {
        int wallAngle;
        int windAngle = this.directionToAngle(windDirection);
        int angleDifference = Math.abs(windAngle - (wallAngle = this.directionToAngle(wallDirection)));
        if (angleDifference > 180) {
            angleDifference = 360 - angleDifference;
        }
        return angleDifference;
    }

    @Unique
    private int directionToAngle(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> 180;
            case Direction.WEST -> 270;
            case Direction.EAST -> 90;
            default -> 0;
        };
    }

    @Unique
    private double calculateDeflectionFactor(double incidenceAngle, double windX, double windZ) {
        double baseDeflection = 0.01;
        double velocityFactor = Math.sqrt(windX * windX + windZ * windZ) * 0.01;
        double angleFactor = Math.cos(Math.toRadians(incidenceAngle));
        return baseDeflection * angleFactor * velocityFactor;
    }

    @Unique
    private boolean checkForLaminarFlow(double incidenceAngle) {
        return incidenceAngle < 45.0;
    }

    @Unique
    private Vec3 adjustWindFlow(Vec3 windEffect, BlockPos pos, double windX, double windZ) {
        Direction wallDirection;
        Direction windDirection = this.getWindDirection(windX, windZ);
        double incidenceAngle = this.calculateIncidenceAngle(windDirection, wallDirection = this.getWallFacingDirection(pos, windDirection));
        if (this.checkForLaminarFlow(incidenceAngle)) {
            return this.slideWindAlongWall(windEffect, wallDirection);
        }
        return this.deflectWind(windX, windZ, pos);
    }

    @Unique
    private Vec3 slideWindAlongWall(Vec3 windEffect, Direction wallDirection) {
        return switch (wallDirection) {
            case Direction.NORTH, Direction.SOUTH -> new Vec3(windEffect.f_82479_, windEffect.f_82480_, 0.0);
            case Direction.WEST, Direction.EAST -> new Vec3(0.0, windEffect.f_82480_, windEffect.f_82481_);
            default -> windEffect;
        };
    }

    @Unique
    private Vec3 funnelWindAroundStructure(Vec3 windEffect, BlockPos pos) {
        Direction wallDirection;
        Direction windDirection = this.getWindDirection(windEffect.f_82479_, windEffect.f_82481_);
        double incidenceAngle = this.calculateIncidenceAngle(windDirection, wallDirection = this.getWallFacingDirection(pos, windDirection));
        if (incidenceAngle >= 45.0 && incidenceAngle <= 135.0) {
            double funnelFactor = 1.0 + (1.0 - Math.cos(Math.toRadians(incidenceAngle))) * 0.5;
            return windEffect.m_82490_(funnelFactor);
        }
        return windEffect;
    }

    @Unique
    private boolean isNearTunnel(BlockPos pos) {
        int airCount = 0;
        int solidCount = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos checkPos = pos.m_7918_(dx, dy, dz);
                    BlockState state = this.f_107208_.m_8055_(checkPos);
                    if (state.m_60795_()) {
                        ++airCount;
                        continue;
                    }
                    if (!state.m_60796_((BlockGetter)this.f_107208_, checkPos)) continue;
                    ++solidCount;
                }
            }
        }
        return airCount >= 15 && solidCount >= 10;
    }

    @Unique
    private Vec3 adjustForTunnelAttraction(Vec3 windEffect, BlockPos pos) {
        if (this.isNearTunnel(pos)) {
            double attractionFactor = 1.5;
            return windEffect.m_82490_(attractionFactor);
        }
        return windEffect;
    }

    @Unique
    private Vec3 calculateRealisticWindFlow(Vec3 windEffect, BlockPos pos) {
        if (this.checkForWallInteraction(pos)) {
            windEffect = this.adjustWindFlow(windEffect, pos, windEffect.f_82479_, windEffect.f_82481_);
        }
        windEffect = this.funnelWindAroundStructure(windEffect, pos);
        return this.adjustForTunnelAttraction(windEffect, pos);
    }
}

