/*
 * Decompiled with CFR 0.152.
 */
package com.quintonc.vs_sails.networking;

import com.quintonc.vs_sails.blocks.entity.BaseHelmBlockEntity;
import com.quintonc.vs_sails.client.ClientWindManager;
import com.quintonc.vs_sails.networking.WheelAngleMessage;
import com.quintonc.vs_sails.networking.WindDataPacket;
import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketHandler {
    public static final ResourceLocation WHEEL_ANGLE_PACKET = new ResourceLocation("vs_sails", "wheel_angle_packet");
    public static final ResourceLocation WIND_DATA_PACKET = new ResourceLocation("vs_sails", "wind_data_packet");
    public static final NetworkChannel CHANNEL = NetworkChannel.create((ResourceLocation)new ResourceLocation("vs_sails", "networking_channel"));

    public static void register() {
        CHANNEL.register(WheelAngleMessage.class, WheelAngleMessage::encode, WheelAngleMessage::new, WheelAngleMessage::apply);
        CHANNEL.register(WindDataPacket.class, WindDataPacket::encode, WindDataPacket::new, WindDataPacket::apply);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)WHEEL_ANGLE_PACKET, (buf, context) -> {
            int wheelAngle = buf.readInt();
            BlockPos pos = buf.m_130135_();
            BlockEntity be = context.getPlayer().m_9236_().m_7702_(pos);
            if (be instanceof BaseHelmBlockEntity) {
                BaseHelmBlockEntity blockEntity = (BaseHelmBlockEntity)be;
                blockEntity.wheelAngle = wheelAngle;
                blockEntity.renderWheelAngleVel = (float)Minecraft.m_91087_().m_260875_() / 20.0f;
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)WIND_DATA_PACKET, (buf, context) -> {
            float str = buf.readFloat();
            float dir = buf.readFloat();
            context.queue(() -> {
                ClientWindManager.windStrength = str;
                ClientWindManager.windDirection = dir;
            });
        });
    }
}

