/*
 * Decompiled with CFR 0.152.
 */
package sypztep.rif.mixin;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sypztep.rif.ModConfig;
import sypztep.rif.util.EntityHurtCallback;
import sypztep.rif.util.PlayerAttackCallback;
import sypztep.rif.util.PlayerEntityAccessor;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements PlayerEntityAccessor {
    @Unique
    private boolean swinging = false;
    @Unique
    private long lastAttackTime = 0L;
    @Unique
    private int rapidAttackCount = 0;

    @Override
    public void setSwingingHand(boolean swinging) {
        this.swinging = swinging;
    }

    @Override
    public boolean isSwingingHand() {
        return this.swinging;
    }

    @Inject(at={@At(value="HEAD")}, method={"attack"}, cancellable=true)
    private void onPlayerAttack(class_1297 target, CallbackInfo ci) {
        class_1269 result = ((PlayerAttackCallback)PlayerAttackCallback.EVENT.invoker()).attackEntity((class_1657)this, target);
        if (result == class_1269.field_5814) {
            ci.cancel();
        }
        if (ModConfig.rapidAttackDamageFalloff <= 0.0f) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        this.rapidAttackCount = currentTime - this.lastAttackTime < ModConfig.rapidAttackThreshold ? Math.min(this.rapidAttackCount + 1, ModConfig.maxRapidAttackCount) : Math.max(0, this.rapidAttackCount - 1);
        this.lastAttackTime = currentTime;
    }

    @Inject(at={@At(value="TAIL")}, method={"applyDamage"}, cancellable=true)
    private void onEntityHurt(class_1282 source, float amount, CallbackInfo ci) {
        class_1269 result = ((EntityHurtCallback)EntityHurtCallback.EVENT.invoker()).hurtEntity((class_1309)((class_1657)this), source, amount);
        if (result == class_1269.field_5814) {
            ci.cancel();
        }
    }

    @ModifyVariable(method={"attack"}, at=@At(value="STORE", ordinal=0), ordinal=0)
    private float modifyAttackDamage(float f) {
        if (ModConfig.rapidAttackDamageFalloff <= 0.0f) {
            return f;
        }
        class_1657 player = (class_1657)this;
        class_1799 mainHandItem = player.method_5998(class_1268.field_5808);
        if (mainHandItem.method_7960()) {
            float damageMultiplier = 1.0f - ModConfig.rapidAttackDamageFalloff * (float)this.rapidAttackCount;
            return f * Math.max(ModConfig.minRapidAttackDamage, damageMultiplier);
        }
        return f;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void onTick(CallbackInfo ci) {
        if (System.currentTimeMillis() - this.lastAttackTime > ModConfig.rapidAttackResetTime) {
            this.rapidAttackCount = 0;
        }
    }
}

