/*
 * Decompiled with CFR 0.152.
 */
package me.Blizzard1238562.minicompat;

import me.Blizzard1238562.minicompat.Minicompat;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class MMListener
implements Listener {
    private final Minicompat plugin;
    private final MiniMessage mm = Minicompat.MM;

    public MMListener(Minicompat plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPrepareAnvil(@NotNull PrepareAnvilEvent event) {
        if (!this.plugin.getConfig().getBoolean("anvil-enabled", true)) {
            return;
        }
        AnvilInventory anvilInventory = event.getInventory();
        if (!(anvilInventory instanceof AnvilInventory)) {
            return;
        }
        AnvilInventory anvil = anvilInventory;
        String rename = anvil.getRenameText();
        if (rename == null || rename.isEmpty()) {
            return;
        }
        if (anvil.getViewers().isEmpty()) {
            return;
        }
        Object e = anvil.getViewers().get(0);
        if (!(e instanceof Player)) {
            return;
        }
        Player player = (Player)e;
        if (!player.hasPermission("minicompat.anvil")) {
            return;
        }
        ItemStack result = event.getResult();
        if (result == null) {
            return;
        }
        try {
            Object nameComp = this.mm.deserialize(rename);
            ItemMeta meta = result.getItemMeta();
            if (meta != null) {
                meta.displayName(nameComp);
                result.setItemMeta(meta);
                event.setResult(result);
            }
        }
        catch (Exception ex) {
            this.plugin.getLogger().warning("MiniMessage parse error in anvil rename: " + ex.getMessage());
        }
    }

    @EventHandler
    public void onPlayerChat(@NotNull AsyncPlayerChatEvent event) {
        Object parsedMessage;
        if (!this.plugin.getConfig().getBoolean("chat-enabled", true)) {
            return;
        }
        Player sender = event.getPlayer();
        if (!sender.hasPermission("colorful.chat")) {
            return;
        }
        event.setCancelled(true);
        try {
            parsedMessage = this.mm.deserialize(event.getMessage());
        }
        catch (Exception ex) {
            parsedMessage = Component.text(ChatColor.stripColor((String)event.getMessage()));
        }
        String format = event.getFormat();
        String formattedString = String.format(format, sender.getDisplayName(), event.getMessage());
        TextComponent formattedComponent = LegacyComponentSerializer.legacyAmpersand().deserialize(formattedString);
        int playerIndex = format.indexOf("%1$s");
        int messageIndex = format.indexOf("%2$s");
        String prefix = "";
        String suffix = "";
        if (playerIndex >= 0) {
            prefix = format.substring(0, playerIndex);
            suffix = messageIndex > playerIndex ? format.substring(playerIndex + 4, messageIndex) : format.substring(playerIndex + 4);
        }
        TextComponent prefixComp = LegacyComponentSerializer.legacyAmpersand().deserialize(prefix);
        TextComponent suffixComp = LegacyComponentSerializer.legacyAmpersand().deserialize(suffix);
        TextComponent playerNameComp = Component.text(sender.getDisplayName());
        Component finalMessage = ((TextComponent)((TextComponent)((TextComponent)Component.empty().append(prefixComp)).append(playerNameComp)).append(suffixComp)).append((Component)parsedMessage);
        for (Player recipient : event.getRecipients()) {
            recipient.sendMessage(finalMessage);
        }
        this.plugin.getServer().getConsoleSender().sendMessage(finalMessage);
    }

    @EventHandler
    public void onSignChange(@NotNull SignChangeEvent event) {
        if (!this.plugin.getConfig().getBoolean("signs-enabled", true)) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("minicompat.sign")) {
            return;
        }
        for (int i = 0; i < event.lines().size(); ++i) {
            String line = event.getLine(i);
            if (line == null || line.isEmpty()) continue;
            try {
                Object comp = this.mm.deserialize(line);
                event.line(i, comp);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

