/*
 * Decompiled with CFR 0.152.
 */
package fr.mod;

import fr.mod.Config;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="solosleeper")
public class ModEvents {
    private static long lastSleepingPlayersCount = 0L;

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        long maxExtraTicks;
        long extraTicks;
        ServerLevel overworld = event.getServer().getLevel(Level.OVERWORLD);
        if (overworld == null) {
            return;
        }
        if (!overworld.isNight()) {
            return;
        }
        long sleepingPlayers = 0L;
        long totalPlayersInOverworld = 0L;
        ArrayList<ServerPlayer> playersToNotify = new ArrayList<ServerPlayer>();
        for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
            if (player.level().dimension() != Level.OVERWORLD) continue;
            ++totalPlayersInOverworld;
            if (player.isSleeping()) {
                ++sleepingPlayers;
                if (!Config.titleOnlyForSleepers) continue;
                playersToNotify.add(player);
                continue;
            }
            if (Config.titleOnlyForSleepers) continue;
            playersToNotify.add(player);
        }
        if (!Config.titleOnlyForSleepers) {
            playersToNotify.clear();
            for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
                if (player.level().dimension() != Level.OVERWORLD) continue;
                playersToNotify.add(player);
            }
        }
        if (totalPlayersInOverworld == 0L || sleepingPlayers == 0L) {
            lastSleepingPlayersCount = 0L;
            return;
        }
        double percentSleeping = (double)sleepingPlayers / (double)totalPlayersInOverworld * 100.0;
        if (Config.allowVanillaSkip && percentSleeping >= (double)Config.skipPercentage) {
            lastSleepingPlayersCount = sleepingPlayers;
            return;
        }
        if (percentSleeping < (double)Config.minPlayerPercentage) {
            lastSleepingPlayersCount = sleepingPlayers;
            return;
        }
        if (Config.displaySleepTitle && sleepingPlayers > lastSleepingPlayersCount && sleepingPlayers > 0L) {
            extraTicks = (long)((double)sleepingPlayers * Config.multiplierPerPlayer);
            maxExtraTicks = Config.maxAcceleration - 1;
            if (extraTicks > maxExtraTicks) {
                extraTicks = maxExtraTicks;
            }
            long speedMultiplier = extraTicks + 1L;
            String rawMessage = Config.titleMessageTemplate.replace("{sleeping}", String.valueOf(sleepingPlayers)).replace("{total}", String.valueOf(totalPlayersInOverworld)).replace("{speed}", speedMultiplier + "x");
            MutableComponent titleComponent = Component.literal((String)"");
            MutableComponent subtitleComponent = Component.literal((String)rawMessage);
            ClientboundSetTitlesAnimationPacket animationPacket = new ClientboundSetTitlesAnimationPacket(Config.titleFadeInTicks, Config.titleStayTicks, Config.titleFadeOutTicks);
            for (ServerPlayer player : playersToNotify) {
                if (player.level().dimension() != Level.OVERWORLD) continue;
                player.connection.send((Packet)animationPacket);
                player.connection.send((Packet)new ClientboundSetTitleTextPacket((Component)titleComponent));
                player.connection.send((Packet)new ClientboundSetSubtitleTextPacket((Component)subtitleComponent));
            }
        }
        lastSleepingPlayersCount = sleepingPlayers;
        extraTicks = (long)((double)sleepingPlayers * Config.multiplierPerPlayer);
        maxExtraTicks = Config.maxAcceleration - 1;
        if (extraTicks > maxExtraTicks) {
            extraTicks = maxExtraTicks;
        }
        if (extraTicks > 0L) {
            long currentTime = overworld.getDayTime();
            overworld.setDayTime(currentTime + extraTicks);
        }
    }
}

