/*
 * Decompiled with CFR 0.152.
 */
package fr.mod;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="solosleeper", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.IntValue MIN_PLAYER_PERCENTAGE;
    public static final ForgeConfigSpec.DoubleValue MULTIPLIER_PER_PLAYER;
    public static final ForgeConfigSpec.IntValue MAX_ACCELERATION;
    static final ForgeConfigSpec SPEC;
    public static int minPlayerPercentage;
    public static double multiplierPerPlayer;
    public static int maxAcceleration;

    @SubscribeEvent
    static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.cacheConfig();
        }
    }

    @SubscribeEvent
    static void onReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.cacheConfig();
        }
    }

    private static void cacheConfig() {
        minPlayerPercentage = (Integer)MIN_PLAYER_PERCENTAGE.get();
        multiplierPerPlayer = (Double)MULTIPLIER_PER_PLAYER.get();
        maxAcceleration = (Integer)MAX_ACCELERATION.get();
    }

    static {
        BUILDER.push("SoloSleeper Config");
        MIN_PLAYER_PERCENTAGE = BUILDER.comment(new String[]{"Minimum percentage of players (0-100) that must be sleeping for acceleration to start.", "Default: 0 (activates with just 1 player)"}).defineInRange("minPlayerPercentage", 0, 0, 100);
        MULTIPLIER_PER_PLAYER = BUILDER.comment(new String[]{"Number of additional 'ticks' to add PER sleeping player.", "Ex: 1.0 = 1 player adds 1 tick (x2 speed), 2 players add 2 ticks (x3 speed), etc.", "Default: 5.0"}).defineInRange("multiplierPerPlayer", 5.0, 0.0, 100.0);
        MAX_ACCELERATION = BUILDER.comment(new String[]{"MAXIMUM speed multiplier (e.g., 10 = 10x), regardless of the number of players.", "Default: 20"}).defineInRange("maxAcceleration", 20, 1, 200);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

